% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probability_estimators.R
\name{mr_method}
\alias{mr_method}
\title{Estimation of Failure Probabilities using Median Ranks}
\usage{
mr_method(
  x,
  status = rep(1, length(x)),
  id = NULL,
  method = c("benard", "invbeta"),
  ties.method = c("max", "min", "average")
)
}
\arguments{
\item{x}{A numeric vector which consists of lifetime data. Lifetime
data could be every characteristic influencing the reliability of a product,
e.g. operating time (days/months in service), mileage (km, miles), load
cycles.}

\item{status}{A vector of ones indicating that every unit has failed.}

\item{id}{A vector for the identification of every unit. Default is \code{NULL}.}

\item{method}{Method for the estimation of the cdf. Can be \code{"benard"} (default)
or \code{"invbeta"}.}

\item{ties.method}{A character string specifying how ties are treated,
default is \code{"max"}.}
}
\value{
A tibble with only failed units containing the following columns:
\itemize{
\item \code{id} : Identification for every unit.
\item \code{x} : Lifetime characteristic.
\item \code{status} : Status of failed units (always 1).
\item \code{rank} : Assigned ranks.
\item \code{prob} : Estimated failure probabilities.
\item \code{cdf_estimation_method} : Specified method for the estimation of failure
probabilities (always 'mr').
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#soft-deprecated}{\figure{lifecycle-soft-deprecated.svg}{options: alt='[Soft-deprecated]'}}}{\strong{[Soft-deprecated]}}

\code{mr_method()} is no longer under active development, switching to \link{estimate_cdf}
is recommended.
}
\details{
This non-parametric approach (\emph{Median Ranks}) is used to estimate the
failure probabilities in terms of complete data. Two methods are available to
estimate the cumulative distribution function \emph{F(t)}:
\itemize{
\item \code{"benard"} : Benard's approximation for Median Ranks.
\item \code{"invbeta"} : Exact Median Ranks using the inverse beta distribution.
}
}
\examples{
# Vectors:
obs   <- seq(10000, 100000, 10000)
state <- rep(1, length(obs))
uic   <- c("3435", "1203", "958X", "XX71", "abcd", "tz46",
           "fl29", "AX23", "Uy12", "kl1a")

# Example 1 - Benard's approximation:
tbl_mr <- mr_method(
  x = obs,
  status = state,
  id = uic,
  method = "benard"
)

# Example 2 - Inverse beta distribution:
tbl_mr_invbeta <- mr_method(
  x = obs,
  status = state,
  method = "invbeta"
)

}
