% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WhiteNoise.R
\name{wnRT}
\alias{wnRT}
\title{Weak white noise}
\usage{
wnRT(n, sigma = 1, k = 1, ninit = 100)
}
\arguments{
\item{n}{Number of observations.}

\item{sigma}{Standard deviation.}

\item{k}{Integer \eqn{\neq 0} to prevent a zero denominator.}

\item{ninit}{Length of 'burn-in' period.}
}
\value{
Vector of size \code{n} containing  a nonlinear sequence \eqn{X_{i}} such as
  \eqn{X_i = \frac{Z_{i}}{|Z_{i+1}| + k}} , where \eqn{Z_{i}} is a sequence of iid
    random variables mean-zero random variable with variance \eqn{\sigma^2}.
}
\description{
Simulates an uncorrelated but dependant noise process.
}
\examples{
wnRT(100)
wnRT(100, sigma = 1)
}
\references{
Romano, J. and Thombs, L. 1996, Inference for autocorrelation under weak assumptions,
 \emph{Journal of the American Statistical Association}, vol. 91, no. 434, pp. 590-600
}
\seealso{
\code{\link{wnPT}}, \code{\link{wnPT_SQ}}, \code{\link{simGARCH}}
}
