% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableNormality.R
\name{tableNormality}
\alias{tableNormality}
\title{Create a table for Shapiro Wilk results}
\usage{
tableNormality(
  audioData,
  measure = "duration",
  includeDimensions = FALSE,
  figureNumber = 1,
  nameMeasure = c(),
  HTMLTable = FALSE
)
}
\arguments{
\item{audioData}{A data.frame generated by the autoExtract() function.}

\item{measure}{Name of the dependent variable. Default corresponds to duration.}

\item{includeDimensions}{Logical value indicating if different dimensions should be also included as a factor when testing for normality. Default corresponds to FALSE.}

\item{figureNumber}{Integer indicating the figure number, used to create the title for the table. Default corresponds to 1.}

\item{nameMeasure}{Optional string indicating the name to be displayed for the dependent variable in the output table. If no value is provided, the string used for the measure attribute is displayed.}

\item{HTMLTable}{Logical value indicating if an HTML table should be generated. Default corresponds to FALSE.}
}
\value{
If "HTMLTable" is set to FALSE, this function returns a data.frame with Shapiro-Wilk test results for each condition (if condition column exists) and dimension (if dimension column exists and "includeDimensions" is set to TRUE). Otherwise an HTML table showing test results in APA formatting style is created.
}
\description{
This function returns a data.frame containing Shapiro Wilk results by conditions (and dimensions if "includeDimensions" is set to TRUE). Likewise, if "HTMLTable" is set to TRUE, it outputs results as an HTML table in APA style.
}
\examples{
tableNormality(testAudioData, measure = "duration")

}
