% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board.R
\name{getTopics}
\alias{getTopics}
\title{Returns a list of topics on a community's discussion board}
\usage{
getTopics(
  group_id = "",
  topics_ids = "",
  order = "",
  offset = 0,
  count = 40,
  extended = 0,
  preview = 0,
  preview_length = 90,
  v = getAPIVersion()
)
}
\arguments{
\item{group_id}{ID of the community that owns the discussion board.}

\item{topics_ids}{IDs of topics to be returned (100 maximum). By default, all topics are returned. If this parameter is set, the order, offset, and count parameters are ignored.}

\item{order}{Sort order:
\itemize{
 \item 1 - by date updated in reverse chronological order;
 \item 2 - by date created in reverse chronological order;
 \item -1 - by date updated in chronological order;
 \item -2 - by date created in chronological order.
}
If no sort order is specified, topics are returned in the order specified by the group administrator. Pinned topics are returned first, regardless of the sorting.}

\item{offset}{Offset needed to return a specific subset of topics.}

\item{count}{Number of topics to return (default 40, maximum value 100).}

\item{extended}{1 — to return information about users who created topics or who posted there last; 0 — to return no additional fields (default).}

\item{preview}{1 — to return the first comment in each topic; 2 — to return the last comment in each topic; 0 — to return no comments.}

\item{preview_length}{Number of characters after which to truncate the previewed comment. To preview the full comment, specify 0.}

\item{v}{Version of API}
}
\description{
Returns a list of topics on a community's discussion board
}
