% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{run_ca}
\alias{run_ca}
\title{Shiny App for Correspondence Analysis of Adverse Events}
\usage{
run_ca(
  data,
  id,
  group,
  ae_grade = NULL,
  ae_domain = NULL,
  ae_term = NULL,
  ae_cycle = NULL
)
}
\arguments{
\item{data}{data.frame or tibble object.}

\item{id}{unquoted expression indicating the
variable name in \code{data} that corresponds to the id variable.}

\item{group}{unquoted expression indicating the
variable name in \code{data} that corresponds to the group variable.}

\item{ae_grade}{unquoted expression indicating the
variable name in \code{data} that corresponds to AE grade class.}

\item{ae_domain}{unquoted expression indicating the
variable name in \code{data} that corresponds to AE domain class.}

\item{ae_term}{unquoted expression indicating the
variable name in \code{data} that corresponds to AE term class.}

\item{ae_cycle}{unquoted expression indicating the
variable name in \code{data} that corresponds to AE cycle.}
}
\value{
an interactive web application to perform correspondence analysis
for adverse event data.
}
\description{
Shiny App for Correspondence Analysis of Adverse Events
}
\examples{
if (interactive()) {
library(dplyr)
patient_id <- 1:100
group <- c(rep("A", 50), rep("B", 50))
ae_grade <- sample(1:5, size = 100, replace = TRUE)
ae_domain <- sample(c("C", "D"), size = 100, replace = TRUE)
ae_term <- sample(c("E", "F", "G", "H"), size = 100, replace = TRUE)
dt <- tibble(patient_id = patient_id, trt = group,
            ae_g = ae_grade, ae_d = ae_domain, ae_t = ae_term)
dt \%>\% run_ca(., group = trt,
             id = patient_id,
             ae_grade = ae_g,
             ae_domain = ae_d,
             ae_term = ae_t)
             }

}
