% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_url_relationships.R
\name{get_url_relationships}
\alias{get_url_relationships}
\title{Retrieve relationships for a URL}
\usage{
get_url_relationships(
  url_id = NULL,
  relationship = NULL,
  limit = NULL,
  cursor = NULL,
  ...
)
}
\arguments{
\item{url_id}{URL or URL ID from VirusTotal}

\item{relationship}{Type of relationship: "communicating_files", "downloaded_files", "graphs", "last_serving_ip_address", "network_location", "redirecting_urls", "redirects_to", "referrer_urls", "submissions"}

\item{limit}{Number of relationships to retrieve. Integer. Optional. Default is 10.}

\item{cursor}{String for pagination. Optional.}

\item{\dots}{Additional arguments passed to \code{\link{virustotal_GET}}.}
}
\value{
list containing URL relationships
}
\description{
Retrieve relationships for a URL
}
\examples{
\dontrun{

# Before calling the function, set the API key using set_key('api_key_here')

get_url_relationships(url_id='http://www.google.com', 
                      relationship='communicating_files')
}
}
\references{
\url{https://docs.virustotal.com/reference}
}
\seealso{
\code{\link{set_key}} for setting the API key
}
