% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_nhtsa_url.R
\name{build_nhtsa_url}
\alias{build_nhtsa_url}
\alias{build_vin_url}
\alias{build_vin_batch_url}
\title{Build a NHTSA URL}
\usage{
build_nhtsa_url(endpoint, format = "json", ...)

build_vin_url(vin, ...)

build_vin_batch_url(vin, ...)
}
\arguments{
\item{endpoint}{a string containing the appropriate endpoint. Candidate
endpoints can be found at https://vpic.nhtsa.dot.gov/api/}

\item{format}{the file format to return from the API, one of 'json', 'xml',
or 'csv'. Defaults to 'json'.}

\item{...}{additional arguments to passed on to derived builder functions}

\item{vin}{a string containing the VIN to query.}
}
\value{
\itemize{
\item \code{build_nhtsa_url()} returns a function which will in turn build a url which
points to the specified endpoint on the NHTSA API
\item \code{build_vin_url()} returns a url as a string, formatted to query the NHTSA
\code{DecodeVinValues} endpoint and decode a single VIN.
\item \code{build_vin_batch_url()} returns a url as a string, formatted to query the NHTSA
\verb{DecodeVinBatch Values} endpoint and decode multiple VINs in one call.
}
}
\description{
A family of functions to build URLs for the National Highway Transportation
Safety Administration (NHTSA) vehicle identification number (VIN) decoder API.

The \code{build_nhtsa_url()} function returns a closure containing the appropriate
endpoint and file format request to pass to the NHTSA VIN API.
\itemize{
\item \code{build_vin_url()} takes a single VIN in a character string and returns
an appropriately-formatted url for a NHTSA API request via the
/vehicles/DecodeVINValues/ endpoint.
\item \code{build_vin_batch_url()} takes up to 50 VINs in a character vector and
returns appropriately-formatted url for a NHTSA API request via the
/vehicles/DecodeVINBatchValues/ endpoint.
}
}
\examples{
vin_url_xml <- build_nhtsa_url("/vehicles/DecodeVINValues/", format = "xml")
build_vin_url("3VWLL7AJ9BM053541")
build_vin_batch_url(c("3VWLL7AJ9BM053541", "JH4KA3140KC015221"))
}
