% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupsoft.R
\name{groupsoft}
\alias{groupsoft}
\title{Group soft-thresholding operator}
\usage{
groupsoft(b, lambda, index = 1:length(b), sizegroup = TRUE)
}
\arguments{
\item{b}{a numerical vector.}

\item{lambda}{a positive scalar containing the regularization parameter.}

\item{index}{a vector of integers of size \code{length(b)} containing the group membership for
each element of \code{b}. By default, \code{index=1:length(b)} i.e. each element of \code{b} constitutes its own group.}

\item{sizegroup}{a boolean. if TRUE, the size of 
the groups is taken into account in the thresholding operation.}
}
\value{
Returns the sparse vector after the group soft-thresholding operation.
}
\description{
This function implements the group soft-thresholding operator for a vector which elements are priorly split into groups. For the complete mathematical 
formulation, the reader may refer to the references below.
}
\examples{
b <- c(0.1, 0.2, 0.8, 0.1, 0.1, 0.3)
index <- c(1,1,2,2,3,3)
lambda <- 0.1
groupsoft(b=b, lambda=lambda, index=index, sizegroup=TRUE)
lambda <- 0.3
groupsoft(b=b, lambda=lambda, index=index, sizegroup=TRUE)
lambda <- 0.8
groupsoft(b=b, lambda=lambda, index=index, sizegroup=TRUE)

}
\references{
M. Chavent, J. Lacaille, A. Mourer and M. Olteanu (2020). 
Sparse k-means for mixed data via group-sparse clustering, to appear in ESANN proceedings.

M. Yuan and Y. Lin (2006). Model selection and estimation in regression with grouped variables. J. R. Statist. Soc. B, Vol. 68(1), p. 49-67.
}
\seealso{
\code{\link{groupsparsewkm}}
}
