% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-colorfilters.R
\name{categoricalColorFilter}
\alias{categoricalColorFilter}
\title{Add a visual filter input for categorical data}
\usage{
categoricalColorFilter(inputId, ...)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{...}{
  Arguments passed on to \code{\link[=categoricalLegend]{categoricalLegend}}
  \describe{
    \item{\code{label}}{Display label for the control, or \code{NULL} for no label.}
    \item{\code{class}}{The CSS class of the input div element to match with any filter toggling functions. Default class is \code{"categorical-color-filter"}.}
    \item{\code{values}}{List of character vectors that will match with the colors or palette in the order provided by both.}
    \item{\code{data}}{Alternative vector to extract values with \code{"unique()"} function.}
    \item{\code{colors}}{Colours to match with values; must be a valid argument to
\code{\link[grDevices:col2rgb]{grDevices::col2rgb()}}. This can be a character vector of
\code{"#RRGGBB"} or  \code{"#RRGGBBAA"}, colour names from
\code{\link[grDevices:colors]{grDevices::colors()}}, or a positive integer that indexes into
\code{\link[grDevices:palette]{grDevices::palette()}}.}
    \item{\code{palette}}{A function that outputs a list of colors.}
    \item{\code{orient}}{Orientation of the legend. Can be \code{"bottom"} (default, horizontal with labels below), \code{"top"} (horizontal with labels above), \code{"left"} (vertical with labels on the left)
and \code{"right"} (vertical with labels on the right).}
    \item{\code{size}}{Absolute length in pixels of the color bar; becomes width or height depending on value of \code{orient}. Default is \code{220}.}
    \item{\code{multiple}}{Is selection of multiple items allowed? Default is \code{TRUE}. With \code{FALSE}, selecting one item will de-select the others.}
  }}
}
\value{
A visual filter input control that can be added to a UI definition
}
\description{
Add a visual filter input for categorical data
}
\section{Server value}{

\code{start} and \code{end} bounds of a selection. The default value (or empty selection) is \code{NULL}.
}

\examples{
## Only run examples in interactive R sessions
if (interactive()) {

ui <- fluidPage(
  categoricalColorFilter("filter", data = sort(mtcars$gear), orient = "right",
                           palette = RColorBrewer::brewer.pal(8, "Dark2")),
  verbatimTextOutput("value")
)
server <- function(input, output) {
  output$value <- output$selection <- renderPrint({
  if (!is.null(input$filter)) {
    format(input$filter)
  }
})
}

shinyApp(ui, server)

ui <- fluidPage(
  categoricalColorFilter("filter", label = p("Categorical filter:"),
                           palette = RColorBrewer::brewer.pal(3, "Accent"),
                           values = list("a","b","c")),
  verbatimTextOutput("values")
)
server <- function(input, output) {
  output$value <- output$selection <- renderPrint({
  if (!is.null(input$filter)) {
    format(input$filter)
  }
})
}
shinyApp(ui, server)

}

}
\seealso{
\code{\link[=categoricalLegend]{categoricalLegend()}}

Other visual filters: 
\code{\link{continuousColorFilter}()},
\code{\link{discreteColorFilter}()}
}
\concept{visual filters}
