% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding.r
\encoding{UTF-8}
\name{encode_path}
\alias{encode_path}
\title{Encode detail "path"}
\usage{
encode_path(vl, field = NULL, type, aggregate = NULL, sort = NULL)
}
\arguments{
\item{vl}{Vega-Lite object created by \code{\link{vegalite}}}

\item{field}{single element character vector naming the column}

\item{type}{the encoded field’s type of measurement. This can be either a full type
name (\code{quantitative}, \code{temporal}, \code{ordinal}, and \code{nominal})
or an initial character of the type name (\code{Q}, \code{T}, \code{O}, \code{N}).
This property is case insensitive. If \code{auto} is used, the type will
be guessed (so you may want to actually specify it if you want consistency).}

\item{aggregate}{perform aggregaton on \code{field}. See
\href{http://vega.github.io/vega-lite/docs/aggregate.html}{Supported Aggregation Options} for
more info on valid operations. Leave \code{NULL} for no aggregation.}

\item{sort}{either one of \code{ascending}, \code{descending} or (for ordinal scales)
the result of a call to \code{\link{sort_def}}}
}
\description{
Grouping data is another important operation in visualizing data. For
aggregated plots, all encoded fields without aggregate functions are used as
grouping fields in the aggregation (similar to fields in GROUP BY in SQL).
For line and area marks, mapping a data field to color or shape channel will
group the lines and stacked areas by the field.\cr
\cr
By default, line marks order their points in their paths by the field of
channel x or y. However, to show a pattern of data change over time between x & y
we use path channel to sort points in a paritcular order (e.g. by time).
}
\note{
right now, \code{type} == "\code{auto}" just assume "\code{quantitative}". It
      will eventually get smarter, but you are better off specifying it.
}
\examples{
vegalite() \%>\%
  cell_size(300, 300) \%>\%
  add_data("https://vega.github.io/vega-editor/app/data/driving.json") \%>\%
  encode_x("miles", "quantitative") \%>\%
  encode_y("gas", "quantitative") \%>\%
  encode_path("year", "temporal") \%>\%
  scale_x_linear(zero=FALSE) \%>\%
  scale_y_linear(zero=FALSE) \%>\%
  mark_line()
}
\references{
\href{http://vega.github.io/vega-lite/docs/encoding.html}{Vega-Lite Encoding spec}
}

