% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_ave.R
\name{meta.ave.cronbach}
\alias{meta.ave.cronbach}
\title{Confidence interval for an average Cronbach alpha reliability}
\usage{
meta.ave.cronbach(alpha, n, rel, r, bystudy = TRUE)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{n}{vector of sample sizes}

\item{rel}{vector of sample reliabilities}

\item{r}{number of measurements (e.g., items) used to compute each reliability}

\item{bystudy}{logical to also return each study estimate (TRUE) or not}
}
\value{
Returns a matrix.  The first row is the average estimate across all studies.  If bystudy
is TRUE, there is 1 additional row for each study.  The matrix has the following columns:
\itemize{
\item Estimate - estimated effect size
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for an
average Cronbach reliability coefficient from two or more studies.
}
\examples{
n <- c(583, 470, 546, 680)
rel <- c(.91, .89, .90, .89)
meta.ave.cronbach(.05, n, rel, 10, bystudy = TRUE)

# Should return:
#         Estimate          SE        LL        UL
# Average   0.8975 0.003256081 0.8911102 0.9038592
# Study 1   0.9100 0.005566064 0.8985763 0.9204108
# Study 2   0.8900 0.007579900 0.8743616 0.9041013
# Study 3   0.9000 0.006391375 0.8868623 0.9119356
# Study 4   0.8900 0.006297549 0.8771189 0.9018203


}
\references{
\itemize{
\item \insertRef{Bonett2010}{vcmeta}
\item \insertRef{Bonett2015b}{vcmeta}
}
}
