% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-sunflower.R
\name{position_sunflower}
\alias{position_sunflower}
\title{Arrange over-plotted points in a sunflower pattern}
\usage{
position_sunflower(density = 1, aspect_ratio = 1)
}
\arguments{
\item{density}{The pattern density, which defaults to 1 but will have to be adjusted in most cases.
The desirable density will depend on both the ranges of the axes and the dimensions of the image.}

\item{aspect_ratio}{An aspect ratio adjustment to compensate for distortion of the circular arrangement,
which might occur when plotting if coord_equal() is not used. A wide aspect ratio (eg. 2)
would adjust for vertical stretching, whereas a tall aspect ratio (eg. 0.5) would adjust for
horizontal stretching. The default aspect ratio of 1 is appropriate when no adjustment is required.}
}
\value{
A \code{ggproto} object of class \code{PositionSunflower}.
}
\description{
This function applies the sunflower algorithm, executed by the sunflower() function, as a position adjustment,
arranging overlapping points at any given x and y into a sunflower pattern. See the sunflower() documentation for
more information.
}
\examples{
  library(ggplot2)

  # Use the sunflower position function to arrange N points
  N <- 100

  dat <- data.frame(
    x = rep(1:4, times = N),
    y = rep(1:4, times = N)
  )

  ggplot(dat, aes(x = x, y = y)) +
    geom_point(size = 1, position = position_sunflower(density = 1, aspect_ratio = 1)) +
    xlim(0, 5) +
    ylim(0, 5) +
    coord_equal()

}
\seealso{
Other Functions: 
\code{\link{position_circlepack}()},
\code{\link{position_circlepackdodge}()},
\code{\link{position_jitter_ellipse}()},
\code{\link{position_jitterdodge_ellipse}()},
\code{\link{position_sunflowerdodge}()},
\code{\link{sunflower}()}
}
\concept{Functions}
