% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural_breaks.R
\name{test_structural_breaks}
\alias{test_structural_breaks}
\title{Test for Structural Breaks}
\usage{
test_structural_breaks(panel_data, chow_years = NULL, min_segment = 10L)
}
\arguments{
\item{panel_data}{Data frame in panel format.}

\item{chow_years}{Integer vector of candidate break years for Chow test.
Default NULL uses 1986, 1997, 2001, 2008 if present.}

\item{min_segment}{Integer minimum observations per segment. Default 10.}
}
\value{
A list containing:
\describe{
  \item{chow}{Chow test results for candidate years}
  \item{cusum}{CUSUM test results}
  \item{mosum}{MOSUM test results}
  \item{supf}{supremum F test results}
  \item{breakpoints}{Estimated breakpoint dates}
  \item{aggregated_data}{The aggregated time series used}
}
}
\description{
Performs multiple structural break tests on the aggregated time series
relationship between direct and production prices.
}
\details{
This function aggregates panel data to a single time series by taking
means across sectors, then applies various structural break tests from
the strucchange package.
}
\examples{
\donttest{
if (requireNamespace("strucchange", quietly = TRUE)) {
  set.seed(123)
  years <- 1980:2020
  panel <- data.frame(
    year = rep(years, 5),
    sector = rep(LETTERS[1:5], each = length(years)),
    log_direct = rnorm(length(years) * 5, 5, 0.5),
    log_production = rnorm(length(years) * 5, 5, 0.5)
  )

  break_tests <- test_structural_breaks(panel)
  print(break_tests$cusum)
}
}

}
