% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{robust_summary}
\alias{robust_summary}
\title{Robust Summary Statistics with Bootstrap Confidence Intervals}
\usage{
robust_summary(x, bootstrap_reps = 200L, trim_proportion = 0.1)
}
\arguments{
\item{x}{Numeric vector.}

\item{bootstrap_reps}{Number of bootstrap replications for CI. Default 200.}

\item{trim_proportion}{Proportion to trim for trimmed mean. Default 0.10.}
}
\value{
A list containing:
\describe{
  \item{mean}{Arithmetic mean}
  \item{sd}{Standard deviation}
  \item{median}{Median}
  \item{mad}{Median Absolute Deviation (scaled)}
  \item{tmean}{Trimmed mean}
  \item{ci}{Vector of length 2 with 95 percent bootstrap CI bounds}
}
}
\description{
Computes mean, standard deviation, median, MAD, trimmed mean, and
bootstrap confidence intervals for a numeric vector.
}
\examples{
set.seed(123)
x <- rnorm(50)
robust_summary(x)

}
