% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_model.R
\name{build_model.coxph}
\alias{build_model.coxph}
\title{Build Cox PH models}
\usage{
\method{build_model}{coxph}(
  .object,
  ...,
  .mv = FALSE,
  .test = c("LRT", "Wald"),
  .col.test = FALSE,
  .level = 0.95,
  .stat.pct.sign = TRUE,
  .digits = 1,
  .p.digits = 4
)
}
\arguments{
\item{.object}{An object of class \code{\link[survival]{coxph}}.}

\item{...}{One or more unquoted expressions separated by commas representing
columns in the model data.frame. May be specified using
\code{\link[tidyselect:select_helpers]{tidyselect helpers}}.}

\item{.mv}{A logical. Fit all terms into a single multivariable model. If left
FALSE, all terms are fit in their own univariate models.}

\item{.test}{A character. The name of a \code{\link[stats:add1]{stats::drop1}}
test to use with the model.}

\item{.col.test}{A logical. Append a columns for the test and accompanying
statistic used to derive the p-value.}

\item{.level}{A double. The confidence level required.}

\item{.stat.pct.sign}{A logical. Paste a percent symbol after all reported
frequencies.}

\item{.digits}{An integer. The number of digits to round numbers to.}

\item{.p.digits}{An integer. The number of p-value digits to report. Note
that the p-value still rounded to the number of digits specified in
\code{.digits}.}
}
\value{
An object of class data.frame summarizing the provided object. If the
\code{tibble} package has been installed, a tibble will be returned.
}
\description{
Models specified terms in model data against an existing model
and returns a clean, human readable table of summarizing the effects and
statistics for the newly generated model. This functions greatly simplifies
fitting a large number of variables against a set of time-to-event data.
}
\examples{
library(survival)
library(dplyr)

data_lung <- lung |>
  mutate_at(vars(inst, status, sex), as.factor) |>
  mutate(status = case_when(status == 1 ~ 0, status == 2 ~ 1))

fit <- coxph(Surv(time, status) ~ 1, data = data_lung)

# Create a univariate model for each variable
fit |> build_model(sex, age)
}
\seealso{
\code{\link{build_model}}
}
