% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_TTS.R
\name{filter_dataTTS}
\alias{filter_dataTTS}
\title{Prepare input data for non-parametric TTS calculations.}
\usage{
filter_dataTTS(data, suppression_threshold = 20, uppertime = 365,
  censor_value = 10, decline_buffer = 500, initial_buffer = 3)
}
\arguments{
\item{data}{raw data set. Must be a data frame with the following columns: 'id' - stating the unique identifier for each subject; 'vl' - numeric vector stating the viral load measurements for each subject; 'time' - numeric vector stating the time at which each measurement was taken.}

\item{suppression_threshold}{numeric value indicating the suppression threshold: measurements below this value will be assumed to represent viral suppression. Typically this would be the detection threshold of the assay. Default value is 20.}

\item{uppertime}{the maximum time point to include in the analysis. Subjects who do not suppress viral load below the suppression threshold within this time will be discarded from model fitting. Units are assumed to be the same as the 'time' column. Default value is 365.}

\item{censor_value}{positive numeric value indicating the maximum time point to include in the analysis. Subjects who do not suppress viral load below the detection threshold within this time will be discarded. Units are assumed to be the same as the 'time' column. Default value is 365.}

\item{decline_buffer}{the maximum allowable deviation of values away from a strictly decreasing sequence in viral load. This allows for e.g. measurement noise and small fluctuations in viral load. Default value is 500.}

\item{initial_buffer}{numeric (integer) value indicating the maximum number of initial observations from which the beginning of each trajectory will be chosen. Default value is 3.}
}
\description{
This function prepares the raw input data for TTS interpolation. Individuals whose data do not meet specific inclusion criteria are removed (see Vignette for more details).
}
\details{
Steps include:
1. Setting values below the suppression threshold to half the suppression threshold (following standard practice).
2. Filtering out subjects who do not suppress viral load below the suppression threshold by a certain time.
3. Filtering out subjects who do not have a decreasing sequence of viral load (within some buffer range).
}
\examples{

set.seed(1234567)

simulated_data <- simulate_data(nsubjects = 20)

filter_dataTTS(data = simulated_data)

}
