% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_fun_2.R
\name{simcol}
\alias{simcol}
\title{Find similar colors}
\usage{
simcol(
  col_target,
  col_candidates = colors(),
  tol = c(25, 50, 75),
  distinct = TRUE,
  plot = TRUE
)
}
\arguments{
\item{col_target}{A (required) target color.}

\item{col_candidates}{A palette of color candidates to be considered. 
Default: \code{col_candidates = colors()}.}

\item{tol}{Numeric tolerance value(s) 
(either 1 or 3 numeric values, in the RGB range from 0 to 255).
Values are considered in the order of the RGB value rank in \code{col_target}. 
Default: \code{tol = c(25, 50, 75)}.}

\item{distinct}{Boolean: Return only visually distinct colors? 
Default: \code{distinct = TRUE} (i.e., remove visual duplicates).}

\item{plot}{Boolean: Plot the output (using \code{\link{seecol}})? 
Default: \code{plot = TRUE}.}
}
\value{
A named vector of colors or color values.
}
\description{
\code{simcol} finds and shows colors 
from a palette of color candidates \code{col_candidates} that are similar 
to some target color \code{col_target}.
}
\details{
\code{simcol} returns a vector of the (named) colors or color values in 
\code{col_candidates} (set to \code{colors()} of \strong{grDevices} per default) 
that are similar to the specified target color \code{col_target}. 

If \code{plot = TRUE}, \code{simcol} also visualizes the detected colors  
(by passing its result to \code{\link{seecol}}, as a side-effect).

Color similarity is defined in terms of the distance between colors' RGB values, 
which must be within the numeric tolerance threshold(s) specified by \code{tol} 
(with \code{0 <= tol <= 255}). 
Higher \code{tol} values correspond to more permissive similarity judgments.  

If \code{tol} is a scalar, the values of all three RGB dimensions 
of \code{col_candidates} must be within the corresponding values of 
\code{col_target} to be judged as 'similar'. 
If \code{tol} contains three values, the three RGB dimension are compared 
in order of the dimensions' rank in \code{col_target} 
(i.e., the primary dimension must be within \code{tol[1]}, etc.). 
Thus, providing three \code{tol} values allows for 
more fine-grained similarity matching.
}
\examples{
# Basic uses:
simcol(col_target = "red")
simcol("tan", tol = 15)
simcol(Seeblau, tol = c(20, 30, 40))
simcol("blue", col_candidates = pal_unikn_pref, tol = 120)

# Fine-tuning the range of color matching:
simcol(Seeblau, tol = 30)  # = simcol(Seeblau, tol = c(30, 30, 30))
simcol(Seeblau, tol = c(20, 20, 80))

# Increasing tolerance widens range:
simcol("grey", c("white", "grey", "black"), tol = 255, distinct = FALSE, plot = FALSE)

}
\seealso{
\code{\link{seecol}} for plotting/seeing color palettes; 
\code{\link{usecol}} for using color palettes; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors; 
\code{\link{shades_of}} to defining shades of a given color; 
\code{\link{ac}} for adjusting color transparency.

Other color functions: 
\code{\link{ac}()},
\code{\link{demopal}()},
\code{\link{grepal}()},
\code{\link{newpal}()},
\code{\link{seecol}()},
\code{\link{shades_of}()},
\code{\link{usecol}()}
}
\concept{color functions}
