% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Western_Uni.R
\docType{data}
\name{western_uni}
\alias{western_uni}
\title{Official colours of Western University, Canada}
\format{
An object of class \code{character} of length 3.
}
\source{
Color definitions are based on \href{https://www.uwo.ca}{Western}'s 
\href{http://brand.westernu.ca/colours/}{colour toolkit} (HTML).
}
\usage{
western_uni
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{western_uni} provides the three official colours 
of the \href{https://www.uwo.ca}{Western University}, Canada.
}
\details{
The three primary colours are
\code{"Purple"} (defined as R:79 G:38 B:131, HEX #4F2683),
\code{"Grey (Silver)"} (defined as R:128 G:127 B:131, HEX #807F83), and
\code{"white"} (defined as HEX #FFFFFF).

\code{western_uni} uses the HEX color definitions.
}
\examples{
western_uni
unikn::seecol(western_uni, col_bg = "grey90", 
              main = "The colours of Western University, CA")  # view color palette

}
\seealso{
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colours;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colours.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{concordia_1}},
\code{\link{concordia_2}},
\code{\link{concordia_3}},
\code{\link{concordia_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_1}},
\code{\link{uvic_2}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-06-27.
}
\concept{Canadian university color palettes}
\keyword{datasets}
