% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stanford.R
\docType{data}
\name{stanford_3}
\alias{stanford_3}
\title{Web colors of Stanford University, USA}
\format{
An object of class \code{character} of length 9.
}
\source{
Color definitions are based on \href{https://www.stanford.edu}{Stanford}'s 
\href{https://identity.stanford.edu/design-elements/color/}{Color manual}.
}
\usage{
stanford_3
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{stanford_3} provides the nine web colors
of \href{https://www.stanford.edu}{Stanford University}, CA, USA.
}
\details{
These 9 web colors are
\code{"digital red"} (defined as HEX #B1040E),
\code{"digital red light"} (defined as HEX #E50808),
\code{"digital red dark"} (defined as HEX #820000),
\code{"digital blue"} (defined as HEX #006CB8),
\code{"digital blue light"} (defined as HEX #6FC3FF),
\code{"digital blue dark"} (defined as HEX #00548f),
\code{"digital green"} (defined as HEX #008566),
\code{"digital green light"} (defined as HEX #1AECBA), and
\code{"digital green dark"} (defined as HEX #006F54).


\code{"digital red"} is not a replacement for Cardinal red; 
it can be used as an accent color on digital communications to add energy and emphasis.
\code{"digital red light"} can be used for interactive elements over dark backgrounds for contrast. 
\code{"digital red dark"} can be used for smaller text over light backgrounds.
Use \code{"digital blue"} for links over light backgrounds, 
\code{"digital blue dark"} for link hover/focus states, and 
\code{"digital blue light"} for links over dark backgrounds. 
Do not use these shades of blue in contexts other than links.
Use \code{"digital green"} for things such as form validation, 
\code{"digital green dark"} for link hover/focus states, and 
\code{"digital green light"} for links over dark backgrounds.
}
\examples{
stanford_3
unikn::seecol(stanford_3, main = "Web colors of Stanford University") # view palette

}
\seealso{
\code{\link{stanford_1}} for primary colors of Stanford University;
\code{\link{stanford_2}} for accent colors of Stanford University;
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{cmu_1}},
\code{\link{cmu_2}},
\code{\link{cmu_3}},
\code{\link{columbia_1}},
\code{\link{columbia_2}},
\code{\link{columbia_3}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_2}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_2}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{ucla_1}},
\code{\link{ucla_2}},
\code{\link{ucla_3}},
\code{\link{ucla_4}},
\code{\link{ucsd_1}},
\code{\link{ucsd_2}},
\code{\link{ucsd_3}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-06-14.
}
\concept{U.S. university color palettes}
\keyword{datasets}
