% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_fetch_template}
\alias{system_fetch_template}
\title{Create New Analysis Template}
\usage{
system_fetch_template(
  cfg,
  template = "Simulation",
  overwrite = FALSE,
  output_directory = getwd()
)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{template}{template type}

\item{overwrite}{if \code{TRUE} the new system file will overwrite any existing files present}

\item{output_directory}{directory where workshop files will be placed (getwd())}
}
\value{
List with vectors of template \code{sources}, \code{destinations}
and corresponding write success (\code{write_file}), also a list element
indicating the overall success of the function call (\code{isgood})
}
\description{
Building a system file will produce templates for R and other languages.
This function provides a method to make local copies of these templates.
}
\details{
The template argument can have the following values for the R
workflow:

\itemize{
 \item{"Simulation"}       produces \code{analysis_simulate.R}: R-Script named with placeholders used to run simulations
 \item{"Estimation"}       produces \code{analysis_estimate.R}: R-Script named with placeholders used to perform naive-pooled parameter estimation
 \item{"NCA"}              produces \code{analysis_nca.R}: R-Script to perform non-compartmental analysis (NCA) and report out the results
 \item{"ShinyApp"}         produces \code{ubiquity_app.R}, \code{server.R} and \code{ui.R}: files needed to run the model through a Shiny App either locally or on a Shiny Server
 \item{"Model Diagram"}    produces \code{system.svg}: SVG template for producing a model diagram (Goto \url{https://inkscape.org} for a free SVG editor)
 \item{"Shiny Rmd Report"} produces \code{system_report.Rmd} and \code{test_system_report.R}: R-Markdown file used to generate report tabs for the Shiny App and a script to test it
}

And this will create files to use in other software:

\itemize{
 \item{"Adapt"}            produces \code{system_adapt.for} and \code{system_adapt.prm}: Fortran and parameter files for the currently selected parameter set in Adapt format.
 \item{"Berkeley Madonna"} produces \code{system_berkeley_madonna.txt}: text file with the model and the currently selected parameter set in Berkeley Madonna format
 \item{"nlmixr"}           produces \code{system_nlmixr.R} For the currently selected parameter set to define the system in the `nlmixr` format.
 \item{"NONMEM"}           produces \code{system_nonmem.ctl} For the currently selected parameter set as a NONMEM conntrol stream.
 \item{"Monolix"}          produces \code{system_monolix.txt} and \code{system_monolix.mlxtran} For the currently selected parameter set.
 \item{"mrgsolve"}         produces \code{system_mrgsolve.cpp}: text file with the model and the currently selected parameter set in mrgsolve format  
}
}
\examples{
\donttest{
# Creating a system file from the mab_pk example
fr = system_new(file_name        = "system.txt", 
                system_file      = "mab_pk", 
                overwrite        = TRUE, 
                output_directory = tempdir())

# Building the system 
cfg = build_system(system_file  = file.path(tempdir(), "system.txt"),
      output_directory          = file.path(tempdir(), "output"),
      temporary_directory       = tempdir())

# Creating a simulation template
fr =  system_fetch_template(cfg, 
      template         = "Simulation", 
      output_directory = tempdir())
}
}
