% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.R
\name{measures}
\alias{measures}
\alias{odds_ratio}
\alias{risk_ratio}
\alias{risk_diff}
\title{Measures of effect}
\usage{
odds_ratio(.data, exposure, outcome, alpha = 0.05, ...)

risk_ratio(.data, exposure, outcome, alpha = 0.05, ...)

risk_diff(.data, exposure, outcome, alpha = 0.05, ...)
}
\arguments{
\item{.data}{Either a data frame with observation-level exposure and outcome data or a \link[twoxtwo]{twoxtwo} object}

\item{exposure}{Name of exposure variable; ignored if input to \code{.data} is a \code{twoxtwo} object}

\item{outcome}{Name of outcome variable; ignored if input to \code{.data} is a \code{twoxtwo} object}

\item{alpha}{Significance level to be used for constructing confidence interval; default is \code{0.05}}

\item{...}{Additional arguments passed to \link[twoxtwo]{twoxtwo} function; ignored if input to \code{.data} is a \code{twoxtwo} object}
}
\value{
A \code{tibble} with the following columns:
\itemize{
\item \strong{measure}: Name of the measure calculated
\item \strong{estimate}: Point estimate for the effect measure
\item \strong{ci_lower}: The lower bound of the confidence interval for the estimate
\item \strong{ci_upper}: The upper bound of the confidence interval for the estimate
\item \strong{exposure}: Name of the exposure variable followed by +/- levels (e.g. smoking::yes/no)
\item \strong{outcome}: Name of the outcome variable followed by +/- levels (e.g. heart_disease::yes/no)
}
}
\description{
The \link[twoxtwo]{twoxtwo} framework allows for estimation of the magnitude of association between an exposure and outcome. Measures of effect that can be calculated include odds ratio, risk ratio, and risk difference. Each measure can be calculated as a point estimate as well as the standard error (SE) around that value. It is critical to note that the interpretation of measures of effect depends on the study design and research question being investigated.

The \code{odds_ratio()}, \code{risk_ratio()}, and \code{risk_diff()} functions provide a standard interface for calculating measures of effect. Each function takes an input dataset and arguments for outcome and exposure as bare, unquoted variable names. If the input has the  \link[twoxtwo]{twoxtwo} class then the effect measures will be calculated using exposure and outcome information from that object. The functions all return a tidy \code{tibble} with the name of the measure, the point estimate, and lower/upper bounds of a confidence interval (CI) based on the SE.

Formulas used in point estimate and SE calculations are available in 'Details'.
}
\details{
The formulas below denote cell values as A,B,C,D. For more on \code{twoxtwo} notation see the \link[twoxtwo]{twoxtwo} documentation.
\subsection{Odds Ratio}{

\deqn{OR = (A*D)/(B*C)}

\deqn{seOR = sqrt(1/A + 1/B + 1/C + 1/D)}
}

\subsection{Risk Ratio}{

\deqn{RR = (A/(A+B)) / (C/(C+D))}

\deqn{seRR = sqrt(((1 - (A/(A+B)))/((A+B)*(A/(A+B)))) + ((1-(C/(C+D)))/((C+D)*(C/(C+D)))))}
}

\subsection{Risk Difference}{

\deqn{RD = (A/(A+B)) - (C/(C+D))}

\deqn{seRD = sqrt(((A*B)/((A+B)^3)) + ((C*D)/((C+D)^3)))}
}
}
\references{
Tripepi, G., Jager, K. J., Dekker, F. W., Wanner, C., & Zoccali, C. (2007). Measures of effect: relative risks, odds ratios, risk difference, and 'number needed to treat'. Kidney international, 72(7), 789–791. https://doi.org/10.1038/sj.ki.5002432

Walter S. D. (2000). Choice of effect measure for epidemiological data. Journal of clinical epidemiology, 53(9), 931–939. https://doi.org/10.1016/s0895-4356(00)00210-9

Szklo, M., & Nieto, F. J. (2007). Epidemiology: Beyond the basics. Sudbury, Massachussets: Jones and Bartlett.

Keyes, K.M, & Galea S. (2014). Epidemiology Matters: A new introduction to methodological foundations. New York, New York: Oxford University Press.
}
