% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{insectCounts}
\alias{insectCounts}
\title{Counts of an insect for the combinations of 4 treatments and 6 areas of a field}
\format{a 4 x 6 matrix, where the rows are treatments and the columns are areas of a field.}
\description{
Counts of numbers of an insect, \emph{Leptinotarsa decemlineata} (the
Colorado potato beetle), each of which is the sum for two plots treated
alike, for all combinations of 4 treatments and 6 areas of the field chosen
to be relatively homogeneous.
}
\details{
These data are used in Tukey (1977) Exhibit 1 of Ch 11 and throughout the chapter as examples of
median polish. Because the data are counts, either a sqrt or log transformation would be
reasonable.
}
\examples{
insect.2way <- twoway(insectCounts, method="median")
print(insect.2way, digits=2)

plot(insect.2way)
plot(insect.2way, which="diagnose")

# try sqrt transformation
insect.sqrt <- twoway(sqrt(insectCounts), method="median")
print(insect.sqrt, digits=2)

plot(insect.sqrt)
plot(insect.sqrt, which="diagnose")
}
\references{
Tukey, J. W. (1977). \emph{Exploratory Data Analysis}, Reading MA: Addison-Wesley. Exhibit 1 of chapter 111
}
\keyword{data}
