% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvtools.R
\name{structure.panel}
\alias{structure.panel}
\title{structure.panel}
\usage{
structure.panel(dat, id.name = "id", t1.name = "t1")
}
\arguments{
\item{dat}{A data frame structured as panel data.}

\item{id.name}{The character name of the identifying variable within dat, used to
track subjects across multiple rows of data.}

\item{t1.name}{The character name of the time variable within dat representing the
start (left endpoint) of observation intervals.}
}
\value{
Returns the input data frame sorted by the specified id.name and t1.name,
ensuring that the data for each subject is in chronological order based on the start
time of each observation period. This structured panel data is essential for any
subsequent analyses that depend on the temporal sequence of observations, such as
time-to-event analysis, longitudinal modeling, or any study of changes over time within
subjects.
}
\description{
Sorts the panel data by subject identifier (id) and the beginning of each
observation period (time), ensuring the data is organized sequentially for each subject.
This is a crucial step in preparing panel data for time-series or longitudinal analysis,
where the order of records affects the analysis outcome.
}
