% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{tsconvolve.gogarch.estimate}
\alias{tsconvolve.gogarch.estimate}
\alias{tsconvolve}
\alias{tsconvolve.gogarch.predict}
\alias{tsconvolve.gogarch.simulate}
\title{Convolution}
\usage{
\method{tsconvolve}{gogarch.estimate}(
  object,
  weights = NULL,
  fft_step = 0.001,
  fft_by = 1e-04,
  fft_support = c(-1, 1),
  ...
)

\method{tsconvolve}{gogarch.predict}(
  object,
  weights = NULL,
  fft_step = 0.001,
  fft_by = 1e-04,
  fft_support = c(-1, 1),
  distribution = FALSE,
  ...
)

\method{tsconvolve}{gogarch.simulate}(
  object,
  weights = NULL,
  fft_step = 0.001,
  fft_by = 1e-04,
  fft_support = c(-1, 1),
  distribution = FALSE,
  ...
)
}
\arguments{
\item{object}{an object of class \dQuote{gogarch.estimate}, \dQuote{gogarch.predict}
or \dQuote{gogarch.simulate}.}

\item{weights}{A vector of weights of length equal to the number of series. If
NULL then an equal weight vector is used. A time varying matrix of weights is
also allowed with the correct number of rows (time points or horizon).}

\item{fft_step}{determines the step size for tuning the characteristic function inversion.}

\item{fft_by}{determines the resolution for the equally spaced support given by \code{fft_support}.}

\item{fft_support}{allows either a fixed support range to be given for the inversion else this is
calculated (if NULL) by examining the upper and lower quantiles of each independent factor modeled.
For the Generalized Hyperbolic distribution, it is not recommended to leave this as NULL since
it is quite expensive to calculate the quantiles and will significantly slow down execution time.}

\item{...}{not currently supported.}

\item{distribution}{for the simulated and predicted object, whether to apply to each draw or on the
average across draws (for the predicted object this is the analytic solution rather than the
average).}
}
\value{
an object of class \dQuote{gogarch.fft} or \dQuote{gogarch.fftsim}.
}
\description{
Generates the weighted density of the GOGARCH NIG or GH model.
}
\details{
The Fast Fourier Transformation (FFT) is used to approximate the weighted
density based on its characteristic function. The weighted density is based
on the convolution of the scaled densities of the independent factors, by using
the Jacobian transformation (for more details see the vignette).
The returned object will be a list with the convoluted density for each time point (or each
time point and draw). This can then be passed to the \code{\link{dfft}}, \code{\link{pfft}} or
\code{\link{qfft}} methods which create smooth distributional functions.
}
