% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{logLik.cgarch.estimate}
\alias{logLik.cgarch.estimate}
\alias{logLik}
\alias{logLik.dcc.estimate}
\alias{logLik.gogarch.estimate}
\title{Extract Log-Likelihood}
\usage{
\method{logLik}{cgarch.estimate}(object, ...)

\method{logLik}{dcc.estimate}(object, ...)

\method{logLik}{gogarch.estimate}(object, ...)
}
\arguments{
\item{object}{an estimated object from one of the models in the package.}

\item{...}{none}
}
\value{
An object of class \dQuote{logLik} with attributes for “nobs” and \dQuote{df}.
The latter is equal to the number of estimated parameters, whilst the former is the
number of timesteps (i.e. the number of observations per series).
}
\description{
Extract the log likelihood of the model at the estimated optimal parameter values.
}
\details{
For all models in the package, the log-likelihood is a combination of the univariate
log-likelihood and the multivariate log-likelihood. For the GOGARCH model, being an
independent factor model, this is the sum of the univariate GARCH log-likelihoods
plus a term for the mixing matrix. The number of parameters in the GOGARCH model
reported (\dQuote{df}) represents the univariate independent factor parameters
plus the number of parameters in the rotation matrix U of the ICA algorithm.
}
\author{
Alexios Galanos
}
