% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{estimate.tsissm.spec}
\alias{estimate.tsissm.spec}
\alias{estimate}
\alias{estimate.tsissm.autospec}
\title{Model Estimation}
\usage{
\method{estimate}{tsissm.spec}(
  object,
  solver = "nloptr",
  control = NULL,
  scores = TRUE,
  debug_mode = FALSE,
  ...
)

\method{estimate}{tsissm.autospec}(object, solver = "nloptr", control = NULL, trace = FALSE, ...)
}
\arguments{
\item{object}{an object of class \dQuote{tsissm.spec} or \dQuote{tsissm.autospec}.}

\item{solver}{only \code{nloptr} currently supported.}

\item{control}{solver control parameters (see \code{\link{issm_control}}).}

\item{scores}{whether to calculate the analytic scores (Jacobian) of the
likelihood. This is not available for the \dQuote{tsissm.autospec} object.}

\item{debug_mode}{for development testing, will include the TMB object.}

\item{...}{not used.}

\item{trace}{whether to show a progress bar for the automatic selection object
and also output verbose messages.}
}
\value{
An object of class \dQuote{tsissm.estimate} or \dQuote{tsissm.selection}.
In the case of automatic model selection an object of class \dQuote{tsissm.estimate} 
will be returned based on AIC (minimum) if \dQuote{top_n} is 1, else an object of
class \dQuote{tsissm.selection} with a list of length \dQuote{top_n}. This object
can then be used for filtering, prediction and simulation and then ensembled 
(based on user specified weights).
}
\description{
Estimates a model given a specification object using
maximum likelihood.
}
\details{
The maximum likelihood estimation for this model is described in the 
vignette.
}
\note{
When calculating the scores, a future promise is created so it is fastest if
a future plan is pre-created with at least 2 workers so that the function can 
run in the background without having to wait for the estimation object to be
returned.\cr
If the control argument is NULL, then a hybrid strategy is adopted whereby
the SLSQP algorithm is initially used and if it fails (status less than 0 or errors
due to NaNs in sampled parameters) then the Augmented Lagrange with MMA local 
solver is used which is slower but may be more reliable.\cr
For the automatic selection estimation, this will benefit from the use of multiple
processes which can be set up with a \code{\link[future]{plan}}. For progress
tracing, use \code{\link[progressr]{handlers}}. The function will check for
number of parallel workers initialized (using \sQuote{nbrOfWorkers}), and if 
it finds only 1 then will revert to non-parallel execution of the code.
}
