% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsforecast_1.3.0.R
\name{tsscatterplot}
\alias{tsscatterplot}
\title{Scatter Plot}
\usage{
tsscatterplot(
  x,
  y,
  reg = FALSE,
  title = NULL,
  x.name = NULL,
  y.name = NULL,
  pwidth = 1,
  pcol = "steelblue4",
  regwidth = 0.7,
  regcol = "red"
)
}
\arguments{
\item{x, y}{two univariate time series object or a numeric vector or matrix.}

\item{reg}{optional. A logical value indicating whether a trend line estimated by regression should be included in the scatter plot. Default is \code{FALSE}.}

\item{title}{title of the histogram. Default is \code{NULL}.}

\item{x.name}{name of the series `\code{x}`. If omitted here, the series name found by \code{tsname(x)} will be taken over here. If \code{tsname()} is \code{NULL}, the variable name will be used instead. Default is \code{NULL}.}

\item{y.name}{name of the series `\code{y}`. If omitted here, the series name found by \code{tsname(y)} will be taken over here. If \code{tsname()} is \code{NULL}, the variable name will be used instead. Default is \code{NULL}.}

\item{pwidth}{size of the markers in the scatter plot. Default is \code{1}.}

\item{pcol}{colour of the data points in the scatter plot. Default is `\code{steelblue4}`.}

\item{regwidth}{width of the trend line in the scatter plot. Default is \code{0.7}.}

\item{regcol}{colour of the trend line in the scatter plot. Default is `\code{red}`.}
}
\value{
A scatter plot of \code{x} (values on the x-axis) and \code{y} (values on the y-axis) will be displayed with no further values or objects returned.
}
\description{
Produce a scatter plot of two given univariate time series.
}
\examples{
tsscatterplot(airport$AvgRain, airport$Travellers)
}
\author{
Ka Yui Karl Wu
}
