% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_basic.R
\docType{class}
\name{tscopulafit-class}
\alias{tscopulafit-class}
\alias{sim,tscopulafit-method}
\alias{kendall,tscopulafit-method}
\alias{coef,tscopulafit-method}
\alias{show,tscopulafit-method}
\alias{logLik,tscopulafit-method}
\alias{resid,tscopulafit-method}
\alias{predict,tscopulafit-method}
\title{Fitted time series copula processes}
\usage{
\S4method{sim}{tscopulafit}(object, n = 1000)

\S4method{kendall}{tscopulafit}(object, lagmax = 20)

\S4method{coef}{tscopulafit}(object)

\S4method{show}{tscopulafit}(object)

\S4method{logLik}{tscopulafit}(object)

\S4method{resid}{tscopulafit}(object, trace = FALSE)

\S4method{predict}{tscopulafit}(object, x, type = "df")
}
\arguments{
\item{object}{an object of class \linkS4class{tscopulafit}.}

\item{n}{length of realization.}

\item{lagmax}{maximum value of lag.}

\item{trace}{extract trace instead of residuals.}

\item{x}{vector of arguments of prediction function.}

\item{type}{type of prediction function ("df" for density, "qf" for quantile function
or "dens" for density).}
}
\description{
Class of objects for fitted time series copula processes.
}
\section{Methods (by generic)}{
\itemize{
\item \code{sim(tscopulafit)}: Simulation method for tscopulafit class

\item \code{kendall(tscopulafit)}: Calculate Kendall's tau values for pair copulas for tscopulafit class

\item \code{coef(tscopulafit)}: Coef method for tscopulafit class

\item \code{show(tscopulafit)}: Show method for tscopulafit objects

\item \code{logLik(tscopulafit)}: logLik method for tscopulafit class

\item \code{resid(tscopulafit)}: Residual method for tscopulafit class

\item \code{predict(tscopulafit)}: Prediction method for tscopulafit class

}}
\section{Slots}{

\describe{
\item{\code{tscopula}}{an object of class \linkS4class{tscopula}.}

\item{\code{data}}{a vector or time series of data.}

\item{\code{fit}}{a list containing details of the fit.}
}}

\examples{
ar1 <- armacopula(list(ar = 0.7))
data <- sim(ar1, 1000)
ar1fit <- fit(ar1, data)
sim(ar1fit)
}
