% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mfraccheck.r
\name{mfraccheck}
\alias{mfraccheck}
\title{multifractal check
\code{mfraccheck}  computes the absolute empirical moments of the differenced series for various lags
                   and moment orders. E.g. for lag = 3 and moment order = 1 the average absolute value of 
                   the differences with lag 3 will be computed. By default, the maximum lag is determined 
                   so that the differenced series contains at lest 50 observations.}
\usage{
mfraccheck(p, q_max)
}
\arguments{
\item{p}{the series}

\item{q_max}{maximum moment order}
}
\value{
out list with components:
\item{moments}{matrix with lagmax raws and q_max columns containing the values of the absolute empirical moments }
\item{lagmax}{the maximum lag for differencing}
}
\description{
multifractal check
\code{mfraccheck}  computes the absolute empirical moments of the differenced series for various lags
                   and moment orders. E.g. for lag = 3 and moment order = 1 the average absolute value of 
                   the differences with lag 3 will be computed. By default, the maximum lag is determined 
                   so that the differenced series contains at lest 50 observations.
}
\examples{
data(NIKKEI)
p <- NIKKEI
out <- mfraccheck(log(p),5)
mom <- ts(out$moments,start=1)
ts.plot(mom, log ="xy",xlab="lag",ylab="abs. empirical moments", lty=c(1:5)) 
}
