% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compiled_code_tslstmx.R
\name{embed_columns}
\alias{embed_columns}
\title{Embed columns and create a new data frame}
\usage{
embed_columns(data, n_lag = 2)
}
\arguments{
\item{data}{A data frame containing the original columns.}

\item{n_lag}{Number of lags for embedding.}
}
\value{
A list containing the new data frame and column names of the embedded columns.
}
\description{
This function takes a data frame and embeds specified columns to create a new data frame.
}
\examples{
\donttest{
data <- data.frame(
  Date = as.Date(c("01-04-18", "02-04-18", "03-04-18", "04-04-18", "05-04-18",
                   "06-04-18", "07-04-18", "08-04-18", "09-04-18", "10-04-18",
                   "11-04-18", "12-04-18", "13-04-18", "14-04-18", "15-04-18",
                   "16-04-18", "17-04-18", "18-04-18", "19-04-18", "20-04-18"),
                 format = "\%d-\%m-\%y"),
  A = c(0, 0, 4, 12, 20, 16, 16, 0, 12, 18, 12, 18, 18, 0, 0, 33, 31, 38, 76, 198)
)
check_and_format_data(data)
# Add a new column 'X' based on the values in the second column
data$X <- ifelse(data$A != 0, 1, 0)

result_embed <- embed_columns(data = data, n_lag = 2)
new_data <- result_embed$data_frame
embedded_colnames <- result_embed$column_names
}

}
