% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{rasterize}
\alias{rasterize}
\alias{rasterize,trip,RasterLayer-method}
\alias{rasterize,trip,missing-method}
\title{Rasterize trip objects based on line-segment attributes.}
\arguments{
\item{x}{\code{trip} object}

\item{y}{Raster* object}

\item{field}{attribute from which differences will be calculated, defaults to the time-stamp between trip locations}
}
\value{
RasterLayer
}
\description{
Trip rasterize.
}
\examples{
 d <- data.frame(x=1:10, y=rnorm(10), tms=Sys.time() + 1:10, id=gl(2, 5))
tr <- trip(d, c("tms", "id"))

tr$temp <- sort(runif(nrow(tr)))
r <- rasterize(tr)

rasterize(tr, grid = r)
\donttest{
rasterize(tr, r, field = "temp")
rasterize(tr, method = "density")
rasterize(tr, method = "density", grid = r)

rasterize(tr, r, field = "tms")
rasterize(tr, r)

}

}
