% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minmax_laplace.R
\name{minmax_laplace}
\alias{minmax_laplace}
\title{Laplacian Matrix properties}
\usage{
minmax_laplace(phy, use_rspectra = FALSE)
}
\arguments{
\item{phy}{phylo object or ltable}

\item{use_rspectra}{boolean to indicate whether the helping package RSpectra
should be used, in which case only the minimum and maximum values are
returned}
}
\value{
List with the minimum and maximum eigenvalues
}
\description{
Calculates the eigenvalues of the Laplacian Matrix, where the
Laplacian matrix is the matrix representation of a graph, in this case a
phylogeny.
When the R package \pkg{RSpectra} is available, a faster
calculation can be used, which does not calculate all eigenvalues, but only
the maximum and minimum. As such, when using this option, the vector of all
eigenvalues is not returned.
}
\references{
Chindelevitch, Leonid, et al. "Network science inspires novel
tree shape statistics." Plos one 16.12 (2021): e0259877.
}
