% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitTrawlFunctions.R
\name{fit_DExptrawl}
\alias{fit_DExptrawl}
\title{Fits the trawl function consisting of the weighted sum of two exponential functions}
\usage{
fit_DExptrawl(x, Delta = 1, GMMlag = 5, plotacf = FALSE, lags = 100)
}
\arguments{
\item{x}{vector of equidistant time series data}

\item{Delta}{interval length of the time grid used in the time series, the
default is 1}

\item{GMMlag}{lag length used in the GMM estimation, the default is 5}

\item{plotacf}{binary variable specifying whether or not the empirical and
fitted autocorrelation function should be plotted}

\item{lags}{number of lags to be used in the plot of the autocorrelation
function}
}
\value{
w: the weight parameter (restricted to be in [0,0.5] for
 identifiability reasons)

lambda1: the first memory parameter (denoted by \eqn{\lambda_1} above)

lambda2: the second memory parameter (denoted by \eqn{\lambda_2}
 above)

LM: The Lebesgue measure of the trawl set associated with the double
 exponential trawl
}
\description{
Fits the trawl function consisting of the weighted sum of two exponential functions
}
\details{
The trawl function is parametrised by the three parameters \eqn{0\leq
 w \leq 1} and \eqn{\lambda_1,\lambda_2 > 0} as follows: \deqn{g(x) =
 we^{\lambda_1 x}+(1-w)e^{\lambda_2 x},  \mbox{ for }  x \le 0.} The Lebesgue measure
 of the corresponding trawl set is given by
 \eqn{w/\lambda_1+(1-w)/\lambda_2}.
}
