% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_registry.R
\name{register_vision_model}
\alias{register_vision_model}
\title{Register a Vision Model}
\usage{
register_vision_model(
  name,
  model_id,
  architecture = "clip",
  description = NULL,
  preprocessing_config = NULL,
  requires_special_handling = FALSE
)
}
\arguments{
\item{name}{A short name/alias for the model (e.g., "my-custom-clip")}

\item{model_id}{The HuggingFace model identifier or path to local model}

\item{architecture}{The model architecture type. Currently supported:
\itemize{
  \item \code{"clip"}: Standard CLIP dual-encoder models (default)
  \item \code{"clip-custom"}: CLIP variants requiring special handling
  \item \code{"blip"}: BLIP captioning/VQA models (supported via BLIP adapter)
  \item \code{"align"}: ALIGN dual-encoder models (supported via ALIGN adapter)
}}

\item{description}{Optional description of the model}

\item{preprocessing_config}{Optional list of preprocessing parameters}

\item{requires_special_handling}{Logical indicating if the model needs
custom processing beyond standard CLIP pipeline}
}
\value{
Invisibly returns TRUE if registration successful
}
\description{
Register a new vision model in the transforEmotion registry, making it available
for use with image_scores(), video_scores(), and related functions.
}
\examples{
\dontrun{
# Register a custom CLIP model
register_vision_model(
  name = "my-emotion-clip",
  model_id = "j-hartmann/emotion-english-distilroberta-base",
  architecture = "clip",
  description = "Custom CLIP fine-tuned on emotion datasets"
)

# Register a local model
register_vision_model(
  name = "local-clip",
  model_id = "/path/to/local/model",
  architecture = "clip",
  description = "Locally stored fine-tuned model"
)

# Register experimental BLIP model
register_vision_model(
  name = "blip-caption",
  model_id = "Salesforce/blip-image-captioning-base",
  architecture = "blip",
  description = "BLIP model for image captioning"
)
}
}
