% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rag_sentemo.R
\name{rag_sentemo}
\alias{rag_sentemo}
\title{Structured Emotion/Sentiment via RAG (Small LLMs)}
\usage{
rag_sentemo(
  text = NULL,
  path = NULL,
  task = c("emotion", "sentiment"),
  labels_set = NULL,
  max_labels = 5,
  transformer = c("TinyLLAMA", "Gemma3-1B", "Gemma3-4B", "Qwen3-1.7B", "Ministral-3B"),
  similarity_top_k = 5,
  response_mode = c("compact", "refine", "simple_summarize"),
  output = c("table", "json", "csv"),
  global_analysis = FALSE,
  ...
)
}
\arguments{
\item{text}{Character vector or list. Text to analyze. 
One entry per document.}

\item{path}{Character. Optional directory with files to index (e.g., PDFs).
If provided, overrides \code{text}.}

\item{task}{Character. One of \code{"emotion"} or \code{"sentiment"}.}

\item{labels_set}{Character vector of allowed labels. 
If \code{NULL}, defaults
to Emo8 for \code{task = "emotion"} and c("positive","neutral","negative")
for \code{task = "sentiment"}.}

\item{max_labels}{Integer. Max number of labels to return.}

\item{transformer}{Character. Small local LLM to use. One of:
\itemize{
  \item \code{"TinyLLAMA"} (default)
  \item \code{"Gemma3-1B"}
  \item \code{"Gemma3-4B"}
  \item \code{"Qwen3-0.6B"}
  \item \code{"Qwen3-1.7B"}
  \item \code{"Ministral-3B"}
}}

\item{similarity_top_k}{Integer. Retrieval depth per query. Default 5.}

\item{response_mode}{Character. LlamaIndex response mode. 
Default \code{"compact"}.}

\item{output}{Character. \code{"table"} (default) or \code{"json"}.}

\item{global_analysis}{Logical. If TRUE, analyze all documents 
jointly. Default FALSE.}

\item{...}{Additional arguments passed to \code{rag()} 
(e.g., \code{device}, \code{keep_in_env}).}
}
\value{
For Gemma3-1B/4B and \code{output = "table"}/\code{"csv"}, 
  a data.frame with columns\cr
\code{doc_id, text, label, confidence}.\cr
For Gemma3-1B/4B and \code{output = "json"}, a JSON array 
  of per-doc objects with those fields.\cr
For other models, structured outputs are not supported; 
  the function falls back to \code{output = "text"} and 
  returns a free-text \code{"rag"} object.
}
\description{
Convenience wrapper around \code{rag()} that keeps vector retrieval but
simplifies getting structured outputs for emotion or sentiment analysis
using small local LLMs (1–4B) with sensible defaults.
}
\examples{
\dontrun{
texts <- c(
  "I feel so happy and grateful today!",
  "This is frustrating and makes me angry."
)
rag_sentemo(texts, task = "emotion", output = "table")
rag_sentemo(texts, task = "sentiment", output = "json")
}

}
