% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_language.R
\name{validate.language}
\alias{validate.language}
\title{Validate user-supplied file to translate iatgen generated QSF file}
\usage{
validate.language(file, src_lang = "en")
}
\arguments{
\item{file}{Source CSV file to validate}

\item{src_lang}{Source language -- "en" for english is the only supported one.}
}
\value{
Heading of the second column (language identifier, class: character) if successful, NULL if error
}
\description{
The validate.language function reads in csv file which is expected to contain
2 columns and 28 rows:
\itemize{
\item the first column contains the english language text (as compared to the template file)
\item the second column contains the translation of the first column in a target language
The first rows contains heading -- heading of the first column is "en" for English
and the heading of the second colum is iana formatted target langugage specifier.
}
}
\examples{
my_csv_file <- system.file("langs/en_jp.csv", package = "tr.iatgen")
validate.language(file = my_csv_file)

}
