% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeTextmeta.R
\name{mergeTextmeta}
\alias{mergeTextmeta}
\title{Merge Textmeta Objects}
\usage{
mergeTextmeta(x, all = TRUE)
}
\arguments{
\item{x}{A list of \code{\link{textmeta}} objects}

\item{all}{Logical: Should the result contain
\code{\link{union}} (\code{TRUE}) or \code{\link{intersection}} (\code{FALSE}) of columns of
all objects? If \code{TRUE}, the columns which at least appear in one of
the meta components are filled with \code{NA}s in the merged meta component.}
}
\value{
\code{\link{textmeta}} object
}
\description{
Merges a list of textmeta objects to a single object. It is possible to control whether all
columns or the intersect should be considered.
}
\examples{
texts <- list(A="Give a Man a Fish, and You Feed Him for a Day.
Teach a Man To Fish, and You Feed Him for a Lifetime",
B="So Long, and Thanks for All the Fish",
C="A very able manipulative mathematician, Fisher enjoys a real mastery
in evaluating complicated multiple integrals.")

corpus <- textmeta(meta=data.frame(id=c("A", "B", "C", "D"),
title=c("Fishing", "Don't panic!", "Sir Ronald", "Berlin"),
date=c("1885-01-02", "1979-03-04", "1951-05-06", "1967-06-02"),
additionalVariable=1:4, stringsAsFactors=FALSE), text=texts)

corpus2 <- textmeta(meta=data.frame(id=c("E", "F"),
title=c("title1", "title2"),
date=c("2018-01-01", "2018-01-01"),
additionalVariable2=1:2, stringsAsFactors=FALSE), text=list(E="text1", F="text2"))

merged <- mergeTextmeta(x=list(corpus, corpus2), all = TRUE)
str(merged$meta)

merged <- mergeTextmeta(x=list(corpus, corpus2), all = FALSE)
str(merged$meta)
}
\keyword{manip}
