% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importance_lm.R
\name{importance.lm}
\alias{importance.lm}
\title{Linear Model variable importance plot}
\usage{
\method{importance}{lm}(model_final, model_null, dict = NA, ...)
}
\arguments{
\item{model_final}{a model object}

\item{model_null}{a \code{lm} object for the null model}

\item{dict}{a dictionary to translate the model variables to plotting variables}

\item{...}{arguments passed to other methods}
}
\value{
an object of type \code{importance_plot}
\item{type}{the type of importance plot}
\item{data}{the importance data required for the plot}
}
\description{
Linear Model variable importance plot
}
\examples{
gtest <- lm(mpg ~ cyl*wt*hp + gear + carb, data=mtcars)
gtestreduced <- lm(mpg ~ 1, data=mtcars)
imp <- importance(gtest, gtestreduced)
plot(imp)

gtest <- lm(mpg ~ cyl + wt + hp + gear + carb, data=mtcars)
gtestreduced <- lm(mpg ~ 1, data=mtcars)
imp <- importance(gtest, gtestreduced)
plot(imp)
}
\seealso{
\code{\link{importance}}
}
