% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset-pascal.R
\name{pascal_voc_datasets}
\alias{pascal_voc_datasets}
\alias{pascal_segmentation_dataset}
\alias{pascal_detection_dataset}
\title{Pascal VOC Datasets}
\usage{
pascal_segmentation_dataset(
  root = tempdir(),
  year = "2012",
  split = "train",
  transform = NULL,
  target_transform = NULL,
  download = FALSE
)

pascal_detection_dataset(
  root = tempdir(),
  year = "2012",
  split = "train",
  transform = NULL,
  target_transform = NULL,
  download = FALSE
)
}
\arguments{
\item{root}{Character. Root directory where the dataset will be stored under \verb{root/pascal_voc_<year>}.}

\item{year}{Character. VOC dataset version to use. One of \code{"2007"}, \code{"2008"}, \code{"2009"}, \code{"2010"}, \code{"2011"}, or \code{"2012"}. Default is \code{"2012"}.}

\item{split}{Character. One of \code{"train"}, \code{"val"}, \code{"trainval"}, or \code{"test"}. Determines the dataset split. Default is \code{"train"}.}

\item{transform}{Optional. A function that takes an image and returns a transformed version (e.g., normalization, cropping).}

\item{target_transform}{Optional. A function that transforms the label.}

\item{download}{Logical. If TRUE, downloads the dataset to \verb{root/}. If the dataset is already present, download is skipped.}
}
\value{
A torch dataset of class \code{pascal_segmentation_dataset}.

The returned list inherits class \code{image_with_segmentation_mask}, which allows generic visualization
utilities to be applied.

Each element is a named list with the following structure:
\itemize{
\item \code{x}: a H x W x 3 array representing the RGB image.
\item \code{y}: A named list containing:
\itemize{
\item \code{masks}: A \code{torch_tensor} of dtype \code{bool} and shape \verb{(21, H, W)}, representing a multi-channel segmentation mask.
Each of the 21 channels corresponds to a Pascal VOC classes
\item \code{labels}: An integer vector indicating the indices of the classes present in the mask.
}
}

A torch dataset of class \code{pascal_detection_dataset}.

The returned list inherits class \code{image_with_bounding_box}, which allows generic visualization
utilities to be applied.

Each element is a named list:
\itemize{
\item \code{x}: a H x W x 3 array representing the RGB image.
\item \code{y}: a list with:
\itemize{
\item \code{labels}: a character vector with object class names.
\item \code{boxes}: a tensor of shape (N, 4) with bounding box coordinates in \verb{(xmin, ymin, xmax, ymax)} format.
}
}
}
\description{
Pascal VOC Segmentation Dataset
}
\details{
The Pascal Visual Object Classes (VOC) dataset is a widely used benchmark for object detection and semantic segmentation tasks in computer vision.

This dataset provides RGB images along with per-pixel class segmentation masks for 20 object categories, plus a background class.
Each pixel in the mask is labeled with a class index corresponding to one of the predefined semantic categories.

The VOC dataset was released in yearly editions (2007 to 2012), with slight variations in data splits and annotation formats.
Notably, only the 2007 edition includes a separate \code{test} split; all other years (2008–2012) provide only the \code{train}, \code{val}, and \code{trainval} splits.

The dataset defines 21 semantic classes: \code{"background"}, \code{"aeroplane"}, \code{"bicycle"}, \code{"bird"}, \code{"boat"}, \code{"bottle"}, \code{"bus"}, \code{"car"}, \code{"cat"}, \code{"chair"},
\code{"cow"}, \code{"dining table"}, \code{"dog"}, \code{"horse"}, \code{"motorbike"}, \code{"person"}, \code{"potted plant"}, \code{"sheep"}, \code{"sofa"}, \code{"train"}, and \code{"tv/monitor"}.
They are available through the \code{classes} variable of the dataset object.

This dataset is frequently used for training and evaluating semantic segmentation models, and supports tasks requiring dense, per-pixel annotations.
}
\examples{
\dontrun{
# Load Pascal VOC segmentation dataset (2007 train split)
pascal_seg <- pascal_segmentation_dataset(
 transform = transform_to_tensor,
 download = TRUE,
 year = "2007"
)

# Access the first image and its mask
first_item <- pascal_seg[1]
first_item$x  # Image
first_item$y$masks  # Segmentation mask
first_item$y$labels  # Unique class labels in the mask
pascal_seg$classes[first_item$y$labels]  # Class names

# Visualise the first image and its mask
masked_img <- draw_segmentation_masks(first_item)
tensor_image_browse(masked_img)

# Load Pascal VOC detection dataset (2007 train split)
pascal_det <- pascal_detection_dataset(
 transform = transform_to_tensor,
 download = TRUE,
 year = "2007"
)

# Access the first image and its bounding boxes
first_item <- pascal_det[1]
first_item$x  # Image
first_item$y$labels  # Object labels
first_item$y$boxes  # Bounding box tensor

# Visualise the first image with bounding boxes
boxed_img <- draw_bounding_boxes(first_item)
tensor_image_browse(boxed_img)
}

}
\seealso{
Other segmentation_dataset: 
\code{\link{oxfordiiitpet_segmentation_dataset}()},
\code{\link{rf100_peixos_segmentation_dataset}()}

Other detection_dataset: 
\code{\link{coco_detection_dataset}()},
\code{\link{rf100_biology_collection}()},
\code{\link{rf100_damage_collection}()},
\code{\link{rf100_document_collection}()},
\code{\link{rf100_infrared_collection}()},
\code{\link{rf100_medical_collection}()},
\code{\link{rf100_underwater_collection}()}
}
\concept{detection_dataset}
\concept{segmentation_dataset}
