% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models-efficientnetv2.R
\name{model_efficientnet_v2}
\alias{model_efficientnet_v2}
\alias{model_efficientnet_v2_s}
\alias{model_efficientnet_v2_m}
\alias{model_efficientnet_v2_l}
\title{EfficientNetV2 Models}
\usage{
model_efficientnet_v2_s(pretrained = FALSE, progress = TRUE, ...)

model_efficientnet_v2_m(pretrained = FALSE, progress = TRUE, ...)

model_efficientnet_v2_l(pretrained = FALSE, progress = TRUE, ...)
}
\arguments{
\item{pretrained}{(bool): If TRUE, returns a model pre-trained on ImageNet.}

\item{progress}{(bool): If TRUE, displays a progress bar of the download to
stderr.}

\item{...}{Other parameters passed to the model implementation, such as
\code{num_classes} to change the output dimension.}
}
\description{
Constructs EfficientNetV2 model architectures as described in
\emph{EfficientNetV2: Smaller Models and Faster Training}.
}
\section{Functions}{
\itemize{
\item \code{model_efficientnet_v2_s()}: EfficientNetV2-S model

\item \code{model_efficientnet_v2_m()}: EfficientNetV2-M model

\item \code{model_efficientnet_v2_l()}: EfficientNetV2-L model

}}
\section{Task}{

Image classification with 1000 output classes by default (ImageNet).
}

\section{Input Format}{

The models expect input tensors of shape \code{(batch_size, 3, H, W)}.
Typical values for \code{H} and \code{W} are 384 for V2-S, 480 for V2-M,
and 512 for V2-L.
}

\section{Variants}{

\tabular{lllll}{
\strong{Model} \tab \strong{Resolution} \tab \strong{Params (M)} \tab
\strong{GFLOPs} \tab \strong{Top-1 Acc.} \cr
V2-S \tab 384 \tab 24 \tab 8.4 \tab 83.9 \cr
V2-M \tab 480 \tab 55 \tab 24 \tab 85.1 \cr
V2-L \tab 512 \tab 119 \tab 55 \tab 85.7
}
}

\examples{
\dontrun{
model <- model_efficientnet_v2_s()
input <- torch::torch_randn(1, 3, 224, 224)
output <- model(input)

# Show Top-5 predictions
topk <- output$topk(k = 5, dim = 2)
indices <- as.integer(topk[[2]][1, ])
scores <- as.numeric(topk[[1]][1, ])
glue::glue("{seq_along(indices)}. {imagenet_label(indices)} ({round(scores, 2)}\%)")
}
}
\seealso{
\code{\link{model_efficientnet}}

Other classification_model: 
\code{\link{model_alexnet}()},
\code{\link{model_convnext}},
\code{\link{model_efficientnet}},
\code{\link{model_facenet}},
\code{\link{model_inception_v3}()},
\code{\link{model_maxvit}()},
\code{\link{model_mobilenet_v2}()},
\code{\link{model_mobilenet_v3}},
\code{\link{model_resnet}},
\code{\link{model_vgg}},
\code{\link{model_vit}}
}
\concept{classification_model}
