% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset-caltech.R
\name{caltech_dataset}
\alias{caltech_dataset}
\alias{caltech101_dataset}
\alias{caltech256_dataset}
\title{Caltech Datasets}
\usage{
caltech101_dataset(
  root = tempdir(),
  transform = NULL,
  target_transform = NULL,
  download = FALSE
)

caltech256_dataset(
  root = tempdir(),
  transform = NULL,
  target_transform = NULL,
  download = FALSE
)
}
\arguments{
\item{root}{Character. Root directory for dataset storage. The dataset will be stored under \code{root/caltech256}.}

\item{transform}{Optional function to transform input images after loading. Default is \code{NULL}.}

\item{target_transform}{Optional function to transform labels. Default is \code{NULL}.}

\item{download}{Logical. Whether to download the dataset if not found locally. Default is \code{FALSE}.}
}
\value{
An object of class \code{caltech101_dataset}, which behaves like a torch dataset.
Each element is a named list with:
\itemize{
\item \code{x}: A H x W x 3 integer array representing an RGB image.
\item \code{y}: An Integer representing the label.
}

An object of class \code{caltech256_dataset}, which behaves like a torch dataset.
Each element is a named list with:
\itemize{
\item \code{x}: A H x W x 3 integer array representing an RGB image.
\item \code{y}: An Integer representing the label.
}
}
\description{
Caltech Datasets

Loads the Caltech-256 Object Category Dataset for image classification. It consists of 30,607 images across 256 distinct object categories.
Each category has at least 80 images, with variability in image size.
}
\details{
The Caltech-101 and Caltech-256 collections are \strong{classification} datasets
made of color images with varying sizes. They cover 101 and 256 object
categories respectively and are commonly used for evaluating visual
recognition models.

The Caltech-101 dataset contains around 9,000 images
spread over 101 object categories plus a background class. Images
have varying sizes.

Caltech-256 extends this to about 30,000 images
across 256 categories.
}
\examples{
\dontrun{
caltech101 <- caltech101_dataset(download = TRUE)

first_item <- caltech101[1]
first_item$x  # Image array
first_item$y  # Integer label
}

}
\seealso{
Other classification_dataset: 
\code{\link{cifar10_dataset}()},
\code{\link{eurosat_dataset}()},
\code{\link{fer_dataset}()},
\code{\link{fgvc_aircraft_dataset}()},
\code{\link{flowers102_dataset}()},
\code{\link{image_folder_dataset}()},
\code{\link{lfw_dataset}},
\code{\link{mnist_dataset}()},
\code{\link{oxfordiiitpet_dataset}()},
\code{\link{places365_dataset}()},
\code{\link{tiny_imagenet_dataset}()},
\code{\link{whoi_plankton_dataset}()},
\code{\link{whoi_small_coralnet_dataset}()}
}
\concept{classification_dataset}
