% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{new_annotation_config}
\alias{new_annotation_config}
\title{Visualization functions for the topolow package
Plot Annotation Configuration Class}
\usage{
new_annotation_config(
  notable_points = NULL,
  size = 4.9,
  color = "black",
  alpha = 0.9,
  fontface = "plain",
  box = FALSE,
  segment_size = 0.3,
  segment_alpha = 0.6,
  min_segment_length = 0,
  max_overlaps = Inf,
  outline_size = 0.4
)
}
\arguments{
\item{notable_points}{Character vector of notable points to highlight}

\item{size}{Numeric. Size of annotations for notable points}

\item{color}{Character. Color of annotations for notable points}

\item{alpha}{Numeric. Alpha transparency of annotations}

\item{fontface}{Character. Font face of annotations ("plain", "bold", "italic", etc.)}

\item{box}{Logical. Whether to draw a box around annotations}

\item{segment_size}{Numeric. Size of segments connecting annotations to points}

\item{segment_alpha}{Numeric. Alpha transparency of connecting segments}

\item{min_segment_length}{Numeric. Minimum length of connecting segments}

\item{max_overlaps}{Numeric. Maximum number of overlaps allowed for annotations}

\item{outline_size}{Numeric. Size of the outline for annotations}
}
\value{
An S3 object of class \code{annotation_config}, which is a list
containing the specified configuration parameters for plot annotations.
}
\description{
S3 class for configuring point annotations in plots, including labels,
connecting lines, and visual properties.
}
