% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{radiusOfGyrationDT}
\alias{radiusOfGyrationDT}
\title{Radius of Gyration}
\usage{
radiusOfGyrationDT(lat_col, lon_col, timestamp, dist_measure = "geodesic")
}
\arguments{
\item{lat_col}{Time-ordered vector of latitudes}

\item{lon_col}{Time-ordered vector of longitudes}

\item{timestamp}{Timestamps associated with the latitude/longitude pairs}

\item{dist_measure}{Passed through to geodist::geodist_vec, One of
"haversine" "vincenty", "geodesic", or "cheap" specifying desired method of
geodesic distance calculation.}
}
\value{
Time-weighted radius of gyration
}
\description{
Calculates the time-weighted radius of Gyration provided a data.table
containing latitude, longitude and a timestamp. This is the root-mean-square
time-weighted average of all locations. Weighting by time is provided to
adjust for unequal frequency of data collection.
}
\details{
Time-weighted RoG is defined as
\deqn{ \sqrt{\frac{\sum_i{w_j \times dist([\overline{lon}, \overline{lat}], [lon_j, lat_j]})}{\sum_i{w_j}}}}{sqrt(1/sum(w_j) * sum(w_j * dist(|mean_lon, mean_lat|, |lon_j, lat_j|)^2))}
Where
\deqn{\overline{lon} = \frac{ \sum_j w_j lon_j}{\sum_j w_j} \quad \textrm{and} \quad \overline{lat} = \frac{ \sum_j w_j lat_j}{\sum_j w_j}}{mean_lon = sum(w_j * lon_j)/sum(w_j) and mean_lat = sum(w_j * lat_j)/sum(w_j)}
And the weighting element \eqn{w_j} represents half the time interval during which a location was recorded
\deqn{w_j = \frac{t_{j+1} - t_{j - 1}}{2}}{w_j = (t_j+1 - t_j-1)/2}
}
\examples{
# Inside a data.table
dt <- data.table::data.table(
  lat = c(1, 1, 1, 1, 1),
  lon = c(1, 1.5, 4, 1.5, 2),
  timestamp = c(100, 200, 300, 600, 900)
)
dt[, radiusOfGyrationDT(lat, lon, timestamp)]
# As vectors
radiusOfGyrationDT(
  c(1, 1, 1, 1, 1),
  c(1, 1.5, 4, 1.5, 2),
  c(100, 200, 300, 600, 900)
  )
}
