% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wb_sa.R
\name{wb_sa}
\alias{wb_sa}
\title{Titration Curve for a Weak Base}
\usage{
wb_sa(conc.acid = 0.1, conc.base = 0.1, pka = 9, pkw = 14,
  vol.base = 50, plot = TRUE, eqpt = FALSE, overlay = FALSE, ...)
}
\arguments{
\item{conc.acid}{Molar concentration of the strong acid titrant;
defaults to 0.10 M.}

\item{conc.base}{Molar concentration of the weak base analyte;
defaults to 0.10 M.}

\item{pka}{The pKa value for the weak base analyte's conjugate weak
acid; defaults to a pKa of 9, or a pKb of 5 for the weak base analyte.}

\item{pkw}{The pKw (or pKs) value for the solvent; defaults to water
as a solvent with a pKw of 14.}

\item{vol.base}{Initial volume, in mL, of the solution that 
contains the weak base analyte; defaults to 50.00 mL.}

\item{plot}{Logical; if TRUE, plots the titration curve.}

\item{eqpt}{Logical; if TRUE, draws a vertical line at the titration
curve's equivalence point.}

\item{overlay}{Logical; if TRUE, adds the current titration curve
to the existing titration curve.}

\item{\dots}{Additional arguments to pass to \code{plot()} function.}
}
\value{
A two-column data frame that contains the volume of titrant
in the first column and the solution's pH in the second column. Also
produces a plot of the titration curve with options to display the
equivalence point and to overlay titration curves.
}
\description{
This function calculates and plots the titration curve for a 
monoprotic weak base analyte using a monoprotic strong acid as 
the titrant. The calculation uses a single master equation
that finds the volume of titrant needed to achieve a fixed pH, 
as outlined in R. de Levie's \emph{Principles of Quantitative 
Chemical Analysis} (McGraw-Hill, 1997).
}
\examples{
### Simple titration curve with equivalence point
ex4 = wb_sa(eqpt = TRUE)
head(ex4)

### Overlay titration curves using different pKa values
wb_sa(pka = 9, eqpt = TRUE)
wb_sa(pka = 7, overlay = TRUE)
wb_sa(pka = 5, overlay = TRUE)

### Overlay titration curve for strong base and weak base
sb_sa(eqpt = TRUE)
wb_sa(overlay = TRUE)
}
\author{
David T. Harvey, DePauw University. \email{harvey@depauw.edu}
}

