% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppt_mixture.R
\name{ppt_mixture}
\alias{ppt_mixture}
\title{Precipitation Titration Curve: Mixture of Analytes}
\usage{
ppt_mixture(conc.analyte1 = 0.05, conc.analyte2 = 0.05, vol.analyte = 25,
  conc.titrant = 0.05, pksp1 = 16.08, pksp2 = 11.97, plot = TRUE,
  eqpt = FALSE, overlay = FALSE, ...)
}
\arguments{
\item{conc.analyte1}{Molar concentration of the first analyte; 
defaults to 0.050 M.}

\item{conc.analyte2}{Molar concentration of the second analyte; 
defaults to 0.050 M.}

\item{vol.analyte}{The initial olume, in mL, of the solution 
containing the analyte; defaults to 25.00 mL.}

\item{conc.titrant}{Molar concentration of the titrant; 
defaults to 0.050 M.}

\item{pksp1}{The pKsp value for the first analyte's precipitate; 
defaults to 16.08, which is the pKsp for AgI.}

\item{pksp2}{The pKsp value for the second analyte's precipitate; 
defaults to 11.97, which is the pKsp for AgSCN.}

\item{plot}{Logical; if TRUE, plots the titration curve.}

\item{eqpt}{Logical; if TRUE, draws a vertical line at the titration
curve's equivalence point.}

\item{overlay}{Logical; if TRUE, adds the current titration curve
to the existing titration curve.}

\item{\dots}{Additional arguments to pass to \code{plot()} function.}
}
\value{
A two-column data frame that contains the volume of titrant
in the first column and the solution's pTitrant in the second column. 
Also produces a plot of the titration curve with options to display 
the equivalence point and to overlay titration curves.
}
\description{
This function calculates and plots the precipitation titration curve 
for a mixture of two analytes using a titrant that form precipitates 
with 1:1 stoichiometries. The calculation uses a single master equation
that finds the volume of titrant needed to achieve a fixed 
concentration of titrant, expressed as pTitrant, as outlined in 
R. de Levie's \emph{Principles of Quantitative Chemical Analysis} 
(McGraw-Hill, 1997).
}
\examples{
### Simple titration curve with equivalence points
ex15 = ppt_mixture(eqpt = TRUE)
head(ex15)

### Overlay mixture titration curves using different pKsp values 
ppt_mixture(pksp1 = 16, pksp2 = 12, eqpt = TRUE)
ppt_mixture(pksp1 = 14, pksp2 = 10, overlay = TRUE)
}
\author{
David T. Harvey, DePauw University. \email{harvey@depauw.edu}
}

