% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_clean.R
\name{tt_clean}
\alias{tt_clean}
\title{Create and open cleaning.R}
\usage{
tt_clean(
  path = "tt_submission",
  open = rlang::is_interactive(),
  ignore = FALSE
)
}
\arguments{
\item{path}{The relative path to the directory to hold your submission files
(\code{tt_submission} by default). If this directory does not exist, it will be
created.}

\item{open}{Open the newly created file for editing? Happens in RStudio, if
applicable, or via \code{\link[utils:file.edit]{utils::file.edit()}} otherwise.}

\item{ignore}{Should the newly created file be added to \code{.Rbuildignore}?}
}
\value{
A logical vector indicating whether the file was created or
modified, invisibly.
}
\description{
The first step of curating a TidyTuesday dataset is cleaning the data. This
function creates a simple \code{cleaning.R} file in the specified path (creating
that path if it does not already exist), and (if possible) opens it for
editing.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

  tt_clean()
\dontshow{\}) # examplesIf}
}
