% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group-by-SpatVector.R
\name{group-by.SpatVector}
\alias{group-by.SpatVector}
\alias{group_by.SpatVector}
\alias{ungroup.SpatVector}
\title{Group a \code{SpatVector} by one or more variables}
\usage{
\method{group_by}{SpatVector}(.data, ..., .add = FALSE, .drop = group_by_drop_default(.data))

\method{ungroup}{SpatVector}(x, ...)
}
\arguments{
\item{.data, x}{A \code{SpatVector} object. See \strong{Methods}.}

\item{...}{In \code{group_by()}, variables or computations to group by.
Computations are always done on the ungrouped data frame.
To perform computations on the grouped data, you need to use
a separate \code{mutate()} step before the \code{group_by()}.
Computations are not allowed in \code{nest_by()}.
In \code{ungroup()}, variables to remove from the grouping.}

\item{.add}{When \code{FALSE}, the default, \code{group_by()} will
override existing groups. To add to the existing groups, use
\code{.add = TRUE}.

This argument was previously called \code{add}, but that prevented
creating a new grouping variable called \code{add}, and conflicts with
our naming conventions.}

\item{.drop}{Drop groups formed by factor levels that don't appear in the
data? The default is \code{TRUE} except when \code{.data} has been previously
grouped with \code{.drop = FALSE}. See \code{\link[dplyr:group_by_drop_default]{group_by_drop_default()}} for details.}
}
\value{
A \code{SpatVector} object with an additional attribute.
}
\description{
Most data operations are done on groups defined by variables.
\code{\link[=group_by.SpatVector]{group_by.SpatVector()}} adds new attributes to an existing \code{SpatVector}
indicating the corresponding groups. See \strong{Methods}.
}
\details{
See \strong{Details} on \code{\link[dplyr:group_by]{dplyr::group_by()}}.
}
\section{Methods}{


Implementation of the \strong{generic} \code{\link[dplyr:group_by]{dplyr::group_by()}} family functions for
\code{SpatVector} objects.

\strong{When mixing} \CRANpkg{terra} \strong{and} \CRANpkg{dplyr} \strong{syntax} on a
grouped \code{SpatVector} (i.e, subsetting a \code{SpatVector} like \code{v[1:3,1:2]}) the
\code{groups} attribute can be corrupted. \CRANpkg{tidyterra} would try to
re-group the \code{SpatVector}. This would be triggered the next time you use a
\CRANpkg{dplyr} verb on your \code{SpatVector}.

Note also that some operations (as \code{terra::spatSample()}) would create a new
\code{SpatVector}. In these cases, the result won't preserve the \code{groups}
attribute. Use \code{\link[=group_by]{group_by()}} to re-group.
}

\examples{
\donttest{

library(terra)
f <- system.file("ex/lux.shp", package = "terra")
p <- vect(f)


by_name1 <- p |> group_by(NAME_1)

# grouping doesn't change how the SpatVector looks
by_name1

# But add metadata for grouping: See the coercion to tibble

# Not grouped
p_tbl <- as_tibble(p)
class(p_tbl)
head(p_tbl, 3)

# Grouped
by_name1_tbl <- as_tibble(by_name1)
class(by_name1_tbl)
head(by_name1_tbl, 3)


# It changes how it acts with the other dplyr verbs:
by_name1 |> summarise(
  pop = mean(POP),
  area = sum(AREA)
)

# Each call to summarise() removes a layer of grouping
by_name2_name1 <- p |> group_by(NAME_2, NAME_1)

by_name2_name1
group_data(by_name2_name1)

by_name2 <- by_name2_name1 |> summarise(n = dplyr::n())
by_name2
group_data(by_name2)

# To removing grouping, use ungroup
by_name2 |>
  ungroup() |>
  summarise(n = sum(n))

# By default, group_by() overrides existing grouping
by_name2_name1 |>
  group_by(ID_1, ID_2) |>
  group_vars()


# Use add = TRUE to instead append
by_name2_name1 |>
  group_by(ID_1, ID_2, .add = TRUE) |>
  group_vars()

# You can group by expressions: this is a short-hand
# for a mutate() followed by a group_by()
p |>
  group_by(ID_COMB = ID_1 * 100 / ID_2) |>
  relocate(ID_COMB, .before = 1)
}
}
\seealso{
\code{\link[dplyr:group_by]{dplyr::group_by()}}, \code{\link[dplyr:group_by]{dplyr::ungroup()}}

Other \CRANpkg{dplyr} verbs that operate on group of rows:
\code{\link{count.SpatVector}()},
\code{\link{rowwise.SpatVector}()},
\code{\link{summarise.SpatVector}()}

Other \CRANpkg{dplyr} methods:
\code{\link{arrange.SpatVector}()},
\code{\link{bind_cols.SpatVector}},
\code{\link{bind_rows.SpatVector}},
\code{\link{count.SpatVector}()},
\code{\link{distinct.SpatVector}()},
\code{\link{filter-joins.SpatVector}},
\code{\link{filter.Spat}},
\code{\link{glimpse.Spat}},
\code{\link{mutate-joins.SpatVector}},
\code{\link{mutate.Spat}},
\code{\link{pull.Spat}},
\code{\link{relocate.Spat}},
\code{\link{rename.Spat}},
\code{\link{rowwise.SpatVector}()},
\code{\link{select.Spat}},
\code{\link{slice.Spat}},
\code{\link{summarise.SpatVector}()}
}
\concept{dplyr.groups}
\concept{dplyr.methods}
