% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop-na-Spat.R
\name{drop_na.Spat}
\alias{drop_na.Spat}
\alias{drop_na.SpatVector}
\alias{drop_na.SpatRaster}
\title{Drop attributes of \verb{Spat*} objects containing missing values}
\usage{
\method{drop_na}{SpatVector}(data, ...)

\method{drop_na}{SpatRaster}(data, ...)
}
\arguments{
\item{data}{A \code{SpatVector} created with \code{\link[terra:vect]{terra::vect()}} or a \code{SpatRaster}
\code{\link[terra:rast]{terra::rast()}}.}

\item{...}{<\code{\link[tidyr:tidyr_tidy_select]{tidy-select}}>  Attributes to inspect
for missing values. If empty, all attributes are used.}
}
\value{
A \verb{Spat*} object of the same class than \code{data}. See \strong{Methods}.
}
\description{
\itemize{
\item \code{SpatVector}: \code{drop_na()} method drops geometries where any attribute
specified by \code{...} contains a missing value.
\item \code{SpatRaster}: \code{drop_na()} method drops cells where any layer specified by
\code{...} contains a missing value.
}
}
\section{\CRANpkg{terra} equivalent}{


\code{\link[terra:trim]{terra::trim()}}
}

\section{Methods}{


Implementation of the \strong{generic} \code{\link[tidyr:drop_na]{tidyr::drop_na()}} function.
\subsection{\code{SpatVector}}{

The implementation of this method is performed on a \code{by-attribute} basis,
meaning that \code{NAs} are assessed on the attributes (columns) of each vector
(rows). The result is a \code{SpatVector} with potentially less geometries than
the input.
}

\subsection{\code{SpatRaster}}{

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#questioning}{\figure{lifecycle-questioning.svg}{options: alt='[Questioning]'}}}{\strong{[Questioning]}}

Actual implementation of \verb{drop_na().SpatRaster} can be understood as a
masking method based on the values of the layers (see \code{\link[terra:mask]{terra::mask()}}).

\code{SpatRaster} layers are considered as columns and \code{SpatRaster} cells as rows,
so rows (cells) with any \code{NA} value on any layer would get a \code{NA} value. It
is possible also to mask the cells (rows) based on the values of specific
layers (columns).

\code{drop_na()} would effectively remove outer cells that are \code{NA} (see
\code{\link[terra:trim]{terra::trim()}}), so the extent of the resulting object may differ of the
extent of the input (see \code{\link[terra:resample]{terra::resample()}} for more info).

Check the \strong{Examples} to have a better understanding of this method.
\subsection{Feedback needed!}{

Visit \url{https://github.com/dieghernan/tidyterra/issues}. The implementation
of this method for \code{SpatRaster} may change in the future.
}

}
}

\examples{

library(terra)

f <- system.file("extdata/cyl.gpkg", package = "tidyterra")

v <- terra::vect(f)

# Add NAs
v <- v |> mutate(iso2 = ifelse(cpro <= "09", NA, cpro))

# Init
plot(v, col = "red")

# Mask with lyr.1
v |>
  drop_na(iso2) |>
  plot(col = "red")
# SpatRaster method

\donttest{
r <- rast(
  crs = "EPSG:3857",
  extent = c(0, 10, 0, 10),
  nlyr = 3,
  resolution = c(2.5, 2.5)
)
terra::values(r) <- seq_len(ncell(r) * nlyr(r))


# Add NAs
r[r > 13 & r < 22 | r > 31 & r < 45] <- NA

# Init
plot(r, nc = 3)

# Mask with lyr.1
r |>
  drop_na(lyr.1) |>
  plot(nc = 3)

# Mask with lyr.2
r |>
  drop_na(lyr.2) |>
  plot(nc = 3)

# Mask with lyr.3
r |>
  drop_na(lyr.3) |>
  plot(nc = 3)

# Auto-mask all layers
r |>
  drop_na() |>
  plot(nc = 3)
}
}
\seealso{
\code{\link[tidyr:drop_na]{tidyr::drop_na()}}

Other \CRANpkg{tidyr} verbs for handling missing values:
\code{\link{fill.SpatVector}()},
\code{\link{replace_na.Spat}}

Other \CRANpkg{tidyr} methods:
\code{\link{fill.SpatVector}()},
\code{\link{pivot_longer.SpatVector}()},
\code{\link{pivot_wider.SpatVector}()},
\code{\link{replace_na.Spat}}
}
\concept{tidyr.methods}
\concept{tidyr.missing}
