% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{constraints_api}
\alias{constraints_api}
\alias{add_constraints}
\alias{update_constraints}
\alias{reset_constraints}
\title{Add, update, or reset a \code{constraints} object within an existing \code{roadmap}.}
\usage{
add_constraints(roadmap, constraints)

update_constraints(roadmap, ...)

reset_constraints(roadmap)
}
\arguments{
\item{roadmap}{A \code{roadmap} object}

\item{constraints}{A \code{constraints} object.}

\item{...}{Optional named parameters passed to \code{constraints()}.}
}
\value{
A new \code{roadmap} object.

A roadmap object with added constraints.

A roadmap object with updated constraints.

A roadmap object with reset constraints.
}
\description{
Add, update, or reset a \code{constraints} object within an existing \code{roadmap}.
}
\examples{

rm <- roadmap(
  conf_data = acs_conf_nw,
  start_data = acs_start_nw
)

constraints_df_num <- 
  tibble::tribble(~var, ~min, ~max, ~conditions,
                  "transit_time", 0, 300, "TRUE")

constraints <- constraints(
  schema = rm[["schema"]],
  constraints_df_num = constraints_df_num,
  max_z_num = 0
)

rm |>
  add_constraints(constraints)


rm <- roadmap(
  conf_data = acs_conf_nw,
  start_data = acs_start_nw
)

constraints_df_num <- 
  tibble::tribble(~var, ~min, ~max, ~conditions,
                  "transit_time", 0, 300, "TRUE")

constraints <- constraints(
  schema = rm[["schema"]],
  constraints_df_num = constraints_df_num,
  max_z_num = 0
)

rm |>
  update_constraints(constraints)


rm <- roadmap(
  conf_data = acs_conf_nw,
  start_data = acs_start_nw
)

constraints_df_num <- 
  tibble::tribble(~var, ~min, ~max, ~conditions,
                  "transit_time", 0, 300, "TRUE")

constraints <- constraints(
  schema = rm[["schema"]],
  constraints_df_num = constraints_df_num,
  max_z_num = 0
)

rm <- rm |>
  add_constraints(constraints)

reset_constraints(rm)

}
