% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{options}
\alias{options}
\title{tidynorm Options}
\description{
Options to control the verbosity of tidynorm functions. The convenience function \code{\link[=tidynorm_options]{tidynorm_options()}} will set these options within your current session. For a common behavior across R sessions, set the environment variables as described below. If you've silenced informational messages and want to double check what normalization steps have been taken, use \code{\link[=check_norm]{check_norm()}}.
}
\section{Checking Option Values}{

Option values specific to \code{tidynorm} can be
accessed by passing the package name to \code{env}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{options::opts(env = "tidynorm")

options::opt(x, default, env = "tidynorm")
}\if{html}{\out{</div>}}
}

\section{Options}{

\describe{
\item{tidynorm.silent}{\describe{
Suppress normalization information messages when running a \verb{norm_*()} function.\item{default: }{\preformatted{FALSE}}
\item{option: }{tidynorm.silent}
\item{envvar: }{R_TIDYNORM_TIDYNORM_SILENT (evaluated if possible, raw string otherwise)}
}}

\item{tidynorm.warnings}{\describe{
Print warnings from tidynorm functions.\item{default: }{\preformatted{TRUE}}
\item{option: }{tidynorm.warnings}
\item{envvar: }{R_TIDYNORM_TIDYNORM_WARNINGS (evaluated if possible, raw string otherwise)}
}}

}
}

\seealso{
options getOption Sys.setenv Sys.getenv
}
